/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PrintingUtils {
    public static final String COLUMN_SEPARATOR = "    ";

    public static void printTable(List<String> titles, List<SimpleType> types, List<List<?>> data, Logger log) {
        List<Integer> colSzs = titles.stream().map(String::length).collect(Collectors.toList());
        ArrayList rows = new ArrayList(data.size());
        data.forEach(row -> {
            ListIterator colSzIter = colSzs.listIterator();
            rows.add(row.stream().map(val -> {
                String res = String.valueOf(val);
                colSzIter.set(Math.max((Integer)colSzIter.next(), res.length()));
                return res;
            }).collect(Collectors.toList()));
        });
        PrintingUtils.printRow(titles, Collections.nCopies(titles.size(), SimpleType.STRING), colSzs, log);
        rows.forEach(row -> PrintingUtils.printRow(row, types, colSzs, log));
    }

    private static void printRow(Collection<String> row, Collection<SimpleType> types, Collection<Integer> colSzs, Logger log) {
        Iterator<SimpleType> typeIter = types.iterator();
        Iterator<Integer> colSzsIter = colSzs.iterator();
        log.info(row.stream().map(colVal -> {
            SimpleType colType = (SimpleType)((Object)((Object)typeIter.next()));
            int colSz = (Integer)colSzsIter.next();
            String format = colType == SimpleType.DATE || colType == SimpleType.NUMBER ? "%" + colSz + "s" : "%-" + colSz + "s";
            return String.format(format, colVal);
        }).collect(Collectors.joining(COLUMN_SEPARATOR)));
    }

    public static enum SimpleType {
        DATE,
        NUMBER,
        STRING;

    }
}

