/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.query.KillSubcommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.visor.query.VisorContinuousQueryCancelTask;
import org.apache.ignite.internal.visor.query.VisorContinuousQueryCancelTaskArg;
import org.apache.ignite.internal.visor.query.VisorQueryCancelOnInitiatorTask;
import org.apache.ignite.internal.visor.query.VisorQueryCancelOnInitiatorTaskArg;

public class KillCommand
implements Command<Object> {
    private Object taskArgs;
    private String taskName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Object r = TaskExecutor.executeTaskByNameOnNode(client, this.taskName, this.taskArgs, null, clientCfg);
            return r;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public Object arg() {
        return this.taskArgs;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        KillSubcommand cmd;
        try {
            cmd = KillSubcommand.valueOf((String)argIter.nextArg("Expected type of resource to kill.").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected type of resource to kill.");
        }
        switch (cmd) {
            case SQL: {
                T2 ids = SqlKillQueryCommand.parseGlobalQueryId((String)argIter.nextArg("Expected SQL query id."));
                if (ids == null) {
                    throw new IllegalArgumentException("Expected global query id. Global query id should have format '{node_id}_{query_id}', e.g. '6fa749ee-7cf8-4635-be10-36a1c75267a7_54321'");
                }
                this.taskArgs = new VisorQueryCancelOnInitiatorTaskArg((UUID)ids.get1(), ((Long)ids.get2()).longValue());
                this.taskName = VisorQueryCancelOnInitiatorTask.class.getName();
                break;
            }
            case CONTINUOUS: {
                this.taskArgs = new VisorContinuousQueryCancelTaskArg(UUID.fromString(argIter.nextArg("Expected query originating node id.")), UUID.fromString(argIter.nextArg("Expected continuous query id.")));
                this.taskName = VisorContinuousQueryCancelTask.class.getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown kill subcommand: " + cmd);
            }
        }
    }

    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Kill sql query by query id:", CommandList.KILL, Collections.singletonMap("query_id", "Query identifier."), KillSubcommand.SQL.toString(), "query_id");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("origin_node_id", "Originating node id.");
        params.put("routine_id", "Routine identifier.");
        Command.usage(log, "Kill continuous query by routine id:", CommandList.KILL, params, KillSubcommand.CONTINUOUS.toString(), "origin_node_id", "routine_id");
    }

    @Override
    public String name() {
        return CommandList.KILL.toCommandName();
    }
}

