/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersJobResult;
import org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersTaskArg;
import org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersTaskResult;

public class DrRepairPartitionCountersCommand
extends DrAbstractRemoteSubCommand<VisorDrRepairPartitionCountersTaskArg, VisorDrRepairPartitionCountersTaskResult, Arguments> {
    public static final String CACHES_PARAM = "--caches";
    public static final String BATCH_SIZE = "--batch-size";
    public static final String KEEP_BINARY = "--keep-binary";

    @Override
    protected String visorTaskName() {
        return "org.apache.ignite.internal.visor.dr.VisorDrRepairPartitionCountersTask";
    }

    @Override
    protected void printResult(VisorDrRepairPartitionCountersTaskResult res, Logger log) {
        boolean errors = CommandLogger.printErrors(res.exceptions(), "Dr partition repair task failed on nodes:", log);
        for (Map.Entry nodeEntry : res.results().entrySet()) {
            Collection cacheMetrics = (Collection)nodeEntry.getValue();
            boolean errorWasPrinted = false;
            for (VisorDrRepairPartitionCountersJobResult cacheMetric : cacheMetrics) {
                if (!cacheMetric.hasIssues()) continue;
                errors = true;
                if (!errorWasPrinted) {
                    log.info("  Issues found on node " + nodeEntry.getKey() + ":");
                    errorWasPrinted = true;
                }
                log.info("    " + cacheMetric);
            }
        }
        if (!errors) {
            log.severe("no issues found.");
        } else {
            log.severe("issues found (listed above).");
        }
        log.info("");
    }

    @Override
    protected Arguments parseArguments0(CommandArgIterator argIter) {
        Set<String> caches = null;
        boolean keepBinary = false;
        int batchSize = 100;
        block10: while (argIter.hasNextSubArg()) {
            String nextArg = argIter.nextArg("");
            switch (nextArg.toLowerCase(Locale.ENGLISH)) {
                case "--caches": {
                    caches = CommandArgUtils.validateCachesArgument(argIter.nextCachesSet(CACHES_PARAM), DrSubCommandsList.REPAIR.toString());
                    continue block10;
                }
                case "--batch-size": {
                    batchSize = this.readBatchSizeParam(argIter, nextArg);
                    continue block10;
                }
                case "--keep-binary": {
                    keepBinary = true;
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Argument " + nextArg + " is not supported.");
        }
        return new Arguments(caches, batchSize, keepBinary);
    }

    private int readBatchSizeParam(CommandArgIterator argIter, String nextArg) {
        int numVal;
        if (!argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Numeric value for '" + nextArg + "' parameter expected.");
        }
        String numStr = argIter.nextArg("");
        try {
            numVal = Integer.parseInt(numStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Not numeric value was passed for '" + nextArg + "' parameter: " + numStr);
        }
        if (numVal <= 0) {
            throw new IllegalArgumentException("Value for '" + nextArg + "' property should be positive.");
        }
        return numVal;
    }

    @Override
    public String name() {
        return DrSubCommandsList.REPAIR.text().toUpperCase();
    }

    public static class Arguments
    implements DrAbstractRemoteSubCommand.Arguments<VisorDrRepairPartitionCountersTaskArg> {
        private final Set<String> caches;
        private final int batchSize;
        private final boolean keepBinary;

        public Arguments(Set<String> caches, int batchSize, boolean keepBinary) {
            this.caches = caches;
            this.batchSize = batchSize;
            this.keepBinary = keepBinary;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }

        @Override
        public VisorDrRepairPartitionCountersTaskArg toVisorArgs() {
            return new VisorDrRepairPartitionCountersTaskArg(this.caches, this.batchSize, this.keepBinary);
        }
    }
}

