/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.dr.VisorDrNodeTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrNodeTaskResult;

public class DrNodeCommand
extends DrAbstractRemoteSubCommand<VisorDrNodeTaskArgs, VisorDrNodeTaskResult, DrNodeArguments> {
    public static final String CONFIG_PARAM = "--config";
    public static final String METRICS_PARAM = "--metrics";
    public static final String CLEAR_STORE_PARAM = "--clear-store";
    private UUID nodeId;

    @Override
    protected String visorTaskName() {
        return "org.gridgain.grid.internal.visor.dr.console.VisorDrNodeTask";
    }

    @Override
    public DrNodeArguments parseArguments0(CommandArgIterator argIter) {
        String nextArg;
        String nodeIdStr = argIter.nextArg("nodeId value expected.");
        try {
            this.nodeId = UUID.fromString(nodeIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("nodeId must be UUID.", e);
        }
        boolean config = false;
        boolean metrics = false;
        boolean clearStore = false;
        block12: while ((nextArg = argIter.peekNextArg()) != null) {
            switch (nextArg.toLowerCase(Locale.ENGLISH)) {
                case "--config": {
                    config = true;
                    break;
                }
                case "--metrics": {
                    metrics = true;
                    break;
                }
                case "--clear-store": {
                    clearStore = true;
                    break;
                }
                default: {
                    break block12;
                }
            }
            argIter.nextArg(null);
        }
        return new DrNodeArguments(config, metrics, clearStore);
    }

    @Override
    public String confirmationPrompt() {
        if (((DrNodeArguments)this.arg()).clearStore) {
            return "Warning: this command will clear DR store.";
        }
        return null;
    }

    @Override
    protected VisorDrNodeTaskResult execute0(GridClientConfiguration clientCfg, GridClient client) throws Exception {
        GridClientCompute compute = client.compute();
        Collection connectableNodes = compute.nodes(GridClientNode::connectable);
        if (F.isEmpty((Collection)connectableNodes)) {
            throw new GridClientDisconnectedException("Connectable nodes not found", null);
        }
        GridClientNode node = connectableNodes.stream().filter(n -> this.nodeId.equals(n.nodeId())).findAny().orElse(null);
        if (node == null) {
            node = compute.balancer().balancedNode(connectableNodes);
        }
        return (VisorDrNodeTaskResult)compute.projection(node).execute(this.visorTaskName(), (Object)new VisorTaskArgument(this.nodeId, (Object)((DrNodeArguments)this.arg()).toVisorArgs(), false));
    }

    @Override
    protected void printResult(VisorDrNodeTaskResult res, Logger log) {
        String receiverAddr;
        log.info("Data Center ID: " + res.getDataCenterId());
        log.info("Node addresses: " + res.getAddresses());
        log.info("Mode=" + res.getMode() + (res.getDataNode() ? ", Baseline node" : ""));
        log.info("--------------------------------------------------------------------------------");
        if (res.getDataCenterId() == 0) {
            log.info("Data Replication state: is not configured.");
            return;
        }
        List sndDataCenters = res.getSenderDataCenters();
        if (sndDataCenters != null && !sndDataCenters.isEmpty()) {
            log.info("Node is configured to send data to:");
            for (T2 dataCenter : sndDataCenters) {
                log.info(String.format("  DataCenterId=%d, Addresses=%s", dataCenter.toArray()));
            }
        }
        if ((receiverAddr = res.getReceiverAddress()) != null) {
            log.info("Node is configured to receive data:");
            log.info("  Address=" + receiverAddr);
        }
        if (!res.getResponseMsgs().isEmpty()) {
            log.info("--------------------------------------------------------------------------------");
            for (String responseMsg : res.getResponseMsgs()) {
                log.info(responseMsg);
            }
        }
        DrNodeCommand.printList(log, res.getCommonConfig(), "Common configuration:");
        DrNodeCommand.printList(log, res.getSenderConfig(), "Sender configuration:");
        DrNodeCommand.printList(log, res.getReceiverConfig(), "Receiver configuration:");
        DrNodeCommand.printList(log, res.getSenderMetrics(), "Sender metrics:");
        DrNodeCommand.printList(log, res.getReceiverMetrics(), "Receiver metrics:");
    }

    private static void printList(Logger log, List<T2<String, Object>> cfg, String s) {
        if (cfg != null && !cfg.isEmpty()) {
            log.info(s);
            for (T2<String, Object> t2 : cfg) {
                log.info(String.format("  %s=%s", t2.toArray()));
            }
        }
    }

    @Override
    public String name() {
        return DrSubCommandsList.NODE.text();
    }

    public static class DrNodeArguments
    implements DrAbstractRemoteSubCommand.Arguments<VisorDrNodeTaskArgs> {
        private final boolean config;
        private final boolean metrics;
        private final boolean clearStore;

        public DrNodeArguments(boolean config, boolean metrics, boolean clearStore) {
            this.config = config;
            this.metrics = metrics;
            this.clearStore = clearStore;
        }

        @Override
        public VisorDrNodeTaskArgs toVisorArgs() {
            return new VisorDrNodeTaskArgs(this.config, this.metrics, this.clearStore);
        }
    }
}

