/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersJobResult;
import org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersTaskArg;
import org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersTaskResult;

public class DrCheckPartitionCountersCommand
extends DrAbstractRemoteSubCommand<VisorDrCheckPartitionCountersTaskArg, VisorDrCheckPartitionCountersTaskResult, Arguments> {
    public static final String CHECK_FIRST_PARAM = "--check-first";
    public static final String CACHES_PARAM = "--caches";
    public static final String SCAN_UNTIL_FIRST_ERROR = "--scan-until-first-error";

    @Override
    protected String visorTaskName() {
        return "org.apache.ignite.internal.visor.dr.VisorDrCheckPartitionCountersTask";
    }

    @Override
    protected void printResult(VisorDrCheckPartitionCountersTaskResult res, Logger log) {
        boolean errors = CommandLogger.printErrors(res.exceptions(), "Check partition counters failed on nodes:", log);
        for (Map.Entry nodeEntry : res.results().entrySet()) {
            Collection cacheMetrics = (Collection)nodeEntry.getValue();
            boolean errorWasPrinted = false;
            for (VisorDrCheckPartitionCountersJobResult cacheMetric : cacheMetrics) {
                if (!cacheMetric.hasIssues()) continue;
                errors = true;
                if (!errorWasPrinted) {
                    log.info("  Issues found on node " + nodeEntry.getKey() + ":");
                    errorWasPrinted = true;
                }
                log.info("    " + cacheMetric);
            }
        }
        if (!errors) {
            log.severe("no issues found.");
        } else {
            log.severe("issues found (listed above).");
        }
        log.info("");
    }

    @Override
    protected Arguments parseArguments0(CommandArgIterator argIter) {
        int checkFirst = -1;
        boolean scanUntilFirstError = false;
        Set<String> caches = null;
        block10: while (argIter.hasNextSubArg()) {
            String nextArg = argIter.nextArg("");
            switch (nextArg.toLowerCase(Locale.ENGLISH)) {
                case "--check-first": {
                    checkFirst = this.readCheckFirstParam(argIter, nextArg);
                    continue block10;
                }
                case "--scan-until-first-error": {
                    scanUntilFirstError = true;
                    continue block10;
                }
                case "--caches": {
                    caches = CommandArgUtils.validateCachesArgument(argIter.nextCachesSet(CACHES_PARAM), DrSubCommandsList.CHECK.toString());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Argument " + nextArg + " is not supported.");
        }
        return new Arguments(caches, checkFirst, scanUntilFirstError);
    }

    private int readCheckFirstParam(CommandArgIterator argIter, String nextArg) {
        int numVal;
        if (!argIter.hasNextSubArg()) {
            throw new IllegalArgumentException("Numeric value for '" + nextArg + "' parameter expected.");
        }
        String numStr = argIter.nextArg("");
        try {
            numVal = Integer.parseInt(numStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Not numeric value was passed for '" + nextArg + "' parameter: " + numStr);
        }
        if (numVal <= 0) {
            throw new IllegalArgumentException("Value for '" + nextArg + "' property should be positive.");
        }
        return numVal;
    }

    @Override
    public String name() {
        return DrSubCommandsList.CHECK.text().toUpperCase();
    }

    public class Arguments
    implements DrAbstractRemoteSubCommand.Arguments<VisorDrCheckPartitionCountersTaskArg> {
        private final Set<String> caches;
        private final int checkFirst;
        private final boolean scanUntilFirstError;

        public Arguments(Set<String> caches, int checkFirst, boolean scanUntilFirstError) {
            this.caches = caches;
            this.checkFirst = checkFirst;
            this.scanUntilFirstError = scanUntilFirstError;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }

        @Override
        public VisorDrCheckPartitionCountersTaskArg toVisorArgs() {
            return new VisorDrCheckPartitionCountersTaskArg(this.caches, this.checkFirst, this.scanUntilFirstError);
        }
    }
}

