/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.argument.CommandArg;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.dr.DrSubCommandsList;
import org.apache.ignite.internal.commandline.dr.subcommands.DrAbstractRemoteSubCommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.dr.VisorDrCacheTaskArgs;
import org.apache.ignite.internal.visor.dr.VisorDrCacheTaskResult;

public class DrCacheCommand
extends DrAbstractRemoteSubCommand<VisorDrCacheTaskArgs, VisorDrCacheTaskResult, DrCacheArguments> {
    public static final String CONFIG_PARAM = "--config";
    public static final String METRICS_PARAM = "--metrics";
    public static final String CACHE_FILTER_PARAM = "--cache-filter";
    public static final String SENDER_GROUP_PARAM = "--sender-group";
    public static final String ACTION_PARAM = "--action";

    @Override
    protected String visorTaskName() {
        throw new UnsupportedOperationException("visorTaskName");
    }

    @Override
    public DrCacheArguments parseArguments0(CommandArgIterator argIter) {
        String nextArg;
        Pattern pattern;
        String regex = argIter.nextArg("Cache name regex expected.");
        if (CommandArgIterator.isCommandOrOption(regex)) {
            throw new IllegalArgumentException("Cache name regex expected.");
        }
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Cache name regex is not valid.", e);
        }
        boolean cfg = false;
        boolean metrics = false;
        CacheFilter cacheFilter = CacheFilter.ALL;
        SenderGroup sndGrp = SenderGroup.ALL;
        String sndGrpName = null;
        Action act = null;
        boolean fstSyncMode = false;
        block18: while ((nextArg = argIter.peekNextArg()) != null) {
            switch (nextArg.toLowerCase(Locale.ENGLISH)) {
                case "--config": {
                    argIter.nextArg(null);
                    cfg = true;
                    continue block18;
                }
                case "--metrics": {
                    argIter.nextArg(null);
                    metrics = true;
                    continue block18;
                }
                case "--cache-filter": {
                    argIter.nextArg(null);
                    cacheFilter = argIter.nextEnumOrFail(CacheFilter.class, CACHE_FILTER_PARAM);
                    continue block18;
                }
                case "--sender-group": {
                    argIter.nextArg(null);
                    String arg = argIter.nextArgValue(SENDER_GROUP_PARAM);
                    sndGrp = CommandArgUtils.ofEnum(SenderGroup.class, arg);
                    if (sndGrp != null) continue block18;
                    sndGrpName = arg;
                    continue block18;
                }
                case "--action": {
                    argIter.nextArg(null);
                    act = argIter.nextCmdArgOrFail(Action.class, ACTION_PARAM);
                    continue block18;
                }
                case "--sync": {
                    argIter.nextArg(null);
                    fstSyncMode = true;
                }
            }
            break;
        }
        return new DrCacheArguments(regex, pattern, cfg, metrics, cacheFilter, sndGrp, sndGrpName, act, 0, fstSyncMode);
    }

    @Override
    public String confirmationPrompt() {
        if (((DrCacheArguments)this.arg()).action != null) {
            return "Warning: this command will change data center replication state for selected caches.";
        }
        return null;
    }

    @Override
    protected VisorDrCacheTaskResult execute0(GridClientConfiguration clientCfg, GridClient client) throws Exception {
        return DrCacheCommand.execute0(client, (DrCacheArguments)this.arg());
    }

    public static VisorDrCacheTaskResult execute0(GridClient client, DrCacheArguments arg) throws GridClientException {
        GridClientCompute compute = client.compute();
        Collection nodes = compute.nodes();
        Pattern cacheNamePattern = arg.pattern;
        List nodeIds = nodes.stream().filter(DrAbstractRemoteSubCommand::drControlUtilitySupported).map(GridClientNode::nodeId).collect(Collectors.toList());
        if (F.isEmpty(nodeIds)) {
            throw new GridClientDisconnectedException("Connectable nodes not found", null);
        }
        if (arg.remoteDataCenterId == 0 && arg.action != null) {
            HashMap<String, UUID> cacheNameToNodeMap = new HashMap<String, UUID>();
            for (GridClientNode node : nodes) {
                for (String cacheName : node.caches().keySet()) {
                    if (!cacheNamePattern.matcher(cacheName).matches()) continue;
                    cacheNameToNodeMap.putIfAbsent(cacheName, node.nodeId());
                }
            }
            arg.cacheNamesMap = cacheNameToNodeMap;
        } else if (arg.remoteDataCenterId != 0) {
            for (GridClientNode node : nodes) {
                if (node.attribute("plugins.gg.replication.ist.snd.hub") == null && node.attribute("plugins.gg.replication.snd.hub") == null) continue;
                arg.actionCoordinator = node.nodeId();
                break;
            }
        }
        return (VisorDrCacheTaskResult)compute.projection(DrAbstractRemoteSubCommand::drControlUtilitySupported).execute("org.gridgain.grid.internal.visor.dr.console.VisorDrCacheTask", (Object)new VisorTaskArgument(nodeIds, (Object)arg.toVisorArgs(), false));
    }

    @Override
    protected void printResult(VisorDrCacheTaskResult res, Logger log) {
        this.printUnrecognizedNodesMessage(log, false);
        log.info("Data Center ID: " + res.getDataCenterId());
        log.info("--------------------------------------------------------------------------------");
        if (res.getDataCenterId() == 0) {
            log.info("Data Replication state: is not configured.");
            return;
        }
        List cacheNames = res.getCacheNames();
        if (cacheNames.isEmpty()) {
            log.info("No matching caches found");
            return;
        }
        log.info(String.format("%d matching cache(s): %s", cacheNames.size(), cacheNames));
        for (String cacheName : cacheNames) {
            List cacheSndCfg = (List)res.getSenderConfig().get(cacheName);
            DrCacheCommand.printList(log, cacheSndCfg, String.format("Sender configuration for cache \"%s\":", cacheName));
            List cacheRcvCfg = (List)res.getReceiverConfig().get(cacheName);
            DrCacheCommand.printList(log, cacheRcvCfg, String.format("Receiver configuration for cache \"%s\":", cacheName));
        }
        for (String cacheName : cacheNames) {
            List cacheSndMetrics = (List)res.getSenderMetrics().get(cacheName);
            DrCacheCommand.printList(log, cacheSndMetrics, String.format("Sender metrics for cache \"%s\":", cacheName));
            List cacheRcvMetrics = (List)res.getReceiverMetrics().get(cacheName);
            DrCacheCommand.printList(log, cacheRcvMetrics, String.format("Receiver metrics for cache \"%s\":", cacheName));
        }
        for (String msg : res.getResultMessages()) {
            log.info(msg);
        }
    }

    private static void printList(Logger log, List<T2<String, Object>> cfg, String s) {
        if (cfg != null && !cfg.isEmpty()) {
            log.info(s);
            for (T2<String, Object> t2 : cfg) {
                log.info(String.format("  %s=%s", t2.toArray()));
            }
        }
    }

    @Override
    public String name() {
        return DrSubCommandsList.CACHE.text();
    }

    public static class DrCacheArguments
    implements DrAbstractRemoteSubCommand.Arguments<VisorDrCacheTaskArgs> {
        private final String regex;
        private final Pattern pattern;
        private final boolean config;
        private final boolean metrics;
        private final CacheFilter filter;
        private final SenderGroup senderGroup;
        private final String senderGroupName;
        private final Action action;
        private final byte remoteDataCenterId;
        private Map<String, UUID> cacheNamesMap;
        private UUID actionCoordinator;
        private boolean fstSyncMode;

        public DrCacheArguments(String regex, Pattern pattern, boolean config, boolean metrics, CacheFilter filter, SenderGroup senderGroup, String senderGroupName, Action action, byte remoteDataCenterId, boolean fstSyncMode) {
            this.regex = regex;
            this.pattern = pattern;
            this.config = config;
            this.metrics = metrics;
            this.filter = filter;
            this.senderGroup = senderGroup;
            this.senderGroupName = senderGroupName;
            this.action = action;
            this.remoteDataCenterId = remoteDataCenterId;
            this.fstSyncMode = fstSyncMode;
        }

        public UUID getActionCoordinator() {
            return this.actionCoordinator;
        }

        @Override
        public VisorDrCacheTaskArgs toVisorArgs() {
            return new VisorDrCacheTaskArgs(this.regex, this.config, this.metrics, this.filter.ordinal(), this.senderGroup == null ? 3 : this.senderGroup.ordinal(), this.senderGroupName, this.action == null ? 3 : this.action.ordinal(), this.remoteDataCenterId, this.cacheNamesMap, this.actionCoordinator, this.fstSyncMode);
        }
    }

    public static enum Action implements CommandArg
    {
        STOP("stop"),
        START("start"),
        FULL_STATE_TRANSFER("full-state-transfer");

        private final String name;

        private Action(String name) {
            this.name = name;
        }

        @Override
        public String argName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SenderGroup {
        ALL,
        DEFAULT,
        NONE;

    }

    public static enum CacheFilter {
        ALL,
        SENDING,
        RECEIVING,
        PAUSED,
        ERROR;

    }
}

