/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.dr.subcommands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorTaskArgument;

public abstract class DrAbstractRemoteSubCommand<VisorArgsDto extends IgniteDataTransferObject, VisorResultDto extends IgniteDataTransferObject, DrArgs extends Arguments<VisorArgsDto>>
extends AbstractCommand<DrArgs> {
    private DrArgs args;
    private final List<GridClientNode> nodesWithoutDrTasks = new ArrayList<GridClientNode>();

    protected static boolean drControlUtilitySupported(GridClientNode node) {
        return node.supports(IgniteFeatures.DR_CONTROL_UTILITY);
    }

    @Override
    public final void printUsage(Logger log) {
        throw new UnsupportedOperationException("printUsage");
    }

    @Override
    public final void parseArguments(CommandArgIterator argIter) {
        this.args = this.parseArguments0(argIter);
    }

    @Override
    public final Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            VisorResultDto res = this.execute0(clientCfg, client);
            this.printResult(res, log);
        }
        catch (Throwable e) {
            log.severe("Failed to execute dr command='" + this.name() + "'");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        return null;
    }

    protected VisorResultDto execute0(GridClientConfiguration clientCfg, GridClient client) throws Exception {
        GridClientCompute compute = client.compute();
        Collection nodes = compute.nodes();
        nodes.stream().filter(node -> !DrAbstractRemoteSubCommand.drControlUtilitySupported(node)).collect(Collectors.toCollection(() -> this.nodesWithoutDrTasks));
        List nodeIds = nodes.stream().filter(DrAbstractRemoteSubCommand::drControlUtilitySupported).map(GridClientNode::nodeId).collect(Collectors.toList());
        if (F.isEmpty(nodeIds)) {
            throw new GridClientDisconnectedException("Connectable nodes not found", null);
        }
        return (VisorResultDto)((IgniteDataTransferObject)compute.projection(DrAbstractRemoteSubCommand::drControlUtilitySupported).execute(this.visorTaskName(), (Object)new VisorTaskArgument(nodeIds, this.args.toVisorArgs(), false)));
    }

    protected void printUnrecognizedNodesMessage(Logger log, boolean verbose) {
        if (!this.nodesWithoutDrTasks.isEmpty()) {
            log.warning("Unrecognized nodes found that have no DR API for control utility: " + this.nodesWithoutDrTasks.size());
            if (verbose) {
                for (GridClientNode node : this.nodesWithoutDrTasks) {
                    log.warning(String.format("  nodeId=%s, Mode=%s", node.nodeId(), node.isClient() ? "Client" : "Server"));
                }
            } else {
                log.warning("Please use \"--dr topology\" command to see full list.");
            }
        }
    }

    @Override
    public final DrArgs arg() {
        return this.args;
    }

    protected abstract String visorTaskName();

    protected abstract DrArgs parseArguments0(CommandArgIterator var1);

    protected abstract void printResult(VisorResultDto var1, Logger var2);

    public static interface Arguments<ArgsDto extends IgniteDataTransferObject> {
        public ArgsDto toVisorArgs();
    }
}

