/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.IndexListCommandArg;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.cache.index.IndexListInfoContainer;
import org.apache.ignite.internal.visor.cache.index.IndexListTask;
import org.apache.ignite.internal.visor.cache.index.IndexListTaskArg;

public class CacheIndexesList
extends AbstractCommand<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String desc = "List all indexes that match specified filters.";
        LinkedHashMap map = U.newLinkedHashMap((int)16);
        map.put(IndexListCommandArg.NODE_ID.argName() + " nodeId", "Specify node for job execution. If not specified explicitly, node will be chosen by grid");
        map.put(IndexListCommandArg.GRP_NAME.argName() + " regExp", "Regular expression allowing filtering by cache group name");
        map.put(IndexListCommandArg.CACHE_NAME.argName() + " regExp", "Regular expression allowing filtering by cache name");
        map.put(IndexListCommandArg.IDX_NAME.argName() + " regExp", "Regular expression allowing filtering by index name");
        CacheCommands.usageCache(logger, CacheSubcommands.INDEX_LIST, desc, map, CommandLogger.optional(IndexListCommandArg.NODE_ID + " nodeId"), CommandLogger.optional(IndexListCommandArg.GRP_NAME + " grpRegExp"), CommandLogger.optional(IndexListCommandArg.CACHE_NAME + " cacheRegExp"), CommandLogger.optional(IndexListCommandArg.IDX_NAME + " idxNameRegExp"));
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        Set taskRes;
        block17: {
            UUID nodeId = this.args.nodeId;
            IndexListTaskArg taskArg = new IndexListTaskArg(this.args.groupsRegEx, this.args.cachesRegEx, this.args.indexesRegEx);
            try (GridClient client = Command.startClient(clientCfg);){
                if (GridClientUtils.nodeSupports((UUID)nodeId, (GridClient)client, (IgniteFeatures)IgniteFeatures.INDEXES_MANIPULATIONS_FROM_CONTROL_SCRIPT)) {
                    taskRes = (Set)TaskExecutor.executeTaskByNameOnNode(client, IndexListTask.class.getName(), taskArg, nodeId, clientCfg);
                    break block17;
                }
                if (nodeId == null) {
                    logger.info("Listing indexes is not supported clusterwide. Try specifying node id");
                } else {
                    logger.info("Listing indexes is not supported by node " + nodeId);
                }
                Object var8_8 = null;
                return var8_8;
            }
        }
        this.printIndexes(taskRes, logger);
        return taskRes;
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public String name() {
        return CacheSubcommands.INDEX_LIST.text().toUpperCase();
    }

    @Override
    public void parseArguments(CommandArgIterator argIterator) {
        UUID nodeId = null;
        String groupsRegEx = null;
        String cachesRegEx = null;
        String indexesRegEx = null;
        block6: while (argIterator.hasNextSubArg()) {
            String nextArg = argIterator.nextArg("");
            IndexListCommandArg arg = CommandArgUtils.of(nextArg, IndexListCommandArg.class);
            if (arg == null) {
                throw new IllegalArgumentException("Unknown argument: " + nextArg);
            }
            switch (arg) {
                case NODE_ID: {
                    if (nodeId != null) {
                        throw new IllegalArgumentException(arg.argName() + " arg specified twice.");
                    }
                    nodeId = UUID.fromString(argIterator.nextArg("Failed to read node id."));
                    continue block6;
                }
                case GRP_NAME: {
                    groupsRegEx = argIterator.nextArg("Failed to read group name regex.");
                    if (this.validateRegEx(groupsRegEx)) continue block6;
                    throw new IllegalArgumentException("Invalid group name regex: " + groupsRegEx);
                }
                case CACHE_NAME: {
                    cachesRegEx = argIterator.nextArg("Failed to read cache name regex.");
                    if (this.validateRegEx(cachesRegEx)) continue block6;
                    throw new IllegalArgumentException("Invalid cache name regex: " + cachesRegEx);
                }
                case IDX_NAME: {
                    indexesRegEx = argIterator.nextArg("Failed to read index name regex.");
                    if (this.validateRegEx(indexesRegEx)) continue block6;
                    throw new IllegalArgumentException("Invalid index name regex: " + indexesRegEx);
                }
            }
            throw new IllegalArgumentException("Unknown argument: " + arg.argName());
        }
        this.args = new Arguments(nodeId, groupsRegEx, cachesRegEx, indexesRegEx);
    }

    private void printIndexes(Set<IndexListInfoContainer> res, Logger logger) {
        ArrayList<IndexListInfoContainer> sorted = new ArrayList<IndexListInfoContainer>(res);
        sorted.sort(IndexListInfoContainer.comparator());
        String prevGrpName = "";
        for (IndexListInfoContainer container : sorted) {
            if (!prevGrpName.equals(container.groupName())) {
                prevGrpName = container.groupName();
                logger.info("");
            }
            logger.info(container.toString());
        }
        logger.info("");
    }

    private boolean validateRegEx(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public static class Arguments {
        private UUID nodeId;
        private String groupsRegEx;
        private String cachesRegEx;
        private String indexesRegEx;

        public Arguments(UUID nodeId, String groupsRegEx, String cachesRegEx, String indexesRegEx) {
            this.nodeId = nodeId;
            this.groupsRegEx = groupsRegEx;
            this.indexesRegEx = indexesRegEx;
            this.cachesRegEx = cachesRegEx;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public String groups() {
            return this.groupsRegEx;
        }

        public String cachesRegEx() {
            return this.cachesRegEx;
        }

        public String indexesRegEx() {
            return this.indexesRegEx;
        }

        public String toString() {
            return S.toString(Arguments.class, (Object)this);
        }
    }
}

