/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.CommonArgParser;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.argument.TracingConfigurationCommandArg;
import org.apache.ignite.internal.commandline.tracing.configuration.TracingConfigurationArguments;
import org.apache.ignite.internal.commandline.tracing.configuration.TracingConfigurationSubcommand;
import org.apache.ignite.internal.commandline.util.TopologyUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationTask;
import org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationTaskArg;
import org.apache.ignite.internal.visor.tracing.configuration.VisorTracingConfigurationTaskResult;
import org.apache.ignite.spi.tracing.Scope;

public class TracingConfigurationCommand
extends AbstractCommand<TracingConfigurationArguments> {
    private TracingConfigurationArguments args;

    @Override
    public void printUsage(Logger log) {
        if (!this.experimentalEnabled()) {
            return;
        }
        log.info("");
        log.info("  View or update tracing configuration in a cluster. For more details type:");
        log.info("    " + CommandLogger.join(" ", new Serializable[]{"control.(sh|bat)", CommandList.TRACING_CONFIGURATION, TracingConfigurationSubcommand.HELP}));
    }

    public void printVerboseUsage(Logger log) {
        if (!this.experimentalEnabled()) {
            return;
        }
        log.info("  The '" + (Object)((Object)CommandList.TRACING_CONFIGURATION) + "' is used to get or update tracing configuration. The command has the following syntax:");
        log.info("");
        log.info("  " + CommandLogger.join(" ", "control.(sh|bat)", CommandLogger.join(" ", CommonArgParser.getCommonOptions())) + " " + (Object)((Object)CommandList.TRACING_CONFIGURATION) + " [subcommand <subcommand_parameters>]");
        log.info("");
        log.info("  <scope> value of '" + TracingConfigurationCommandArg.SCOPE.argName() + "' or '" + TracingConfigurationCommandArg.INCLUDED_SCOPES.argName() + "' options in all subcommands can be: " + CommandLogger.join("|", Scope.values()));
        log.info("");
        log.info("");
        log.info("  Subcommands:");
        TracingConfigurationCommand.usageTracing(log, "Print tracing configuration. Works as '" + (Object)((Object)CommandList.TRACING_CONFIGURATION) + " get_all' without params.", null, new String[0]);
        TracingConfigurationCommand.usageTracing(log, "Print tracing configuration for given " + TracingConfigurationCommandArg.SCOPE.argName() + ", or all scopes if nothing was specified.", TracingConfigurationSubcommand.GET_ALL, CommandLogger.optional(TracingConfigurationCommandArg.SCOPE.signature()));
        TracingConfigurationCommand.usageTracing(log, "Print specific tracing configuration based on specified " + TracingConfigurationCommandArg.SCOPE.argName() + " and " + TracingConfigurationCommandArg.LABEL.argName() + '.', TracingConfigurationSubcommand.GET, TracingConfigurationCommandArg.SCOPE.signature(), CommandLogger.optional(TracingConfigurationCommandArg.LABEL.signature()));
        TracingConfigurationCommand.usageTracing(log, "Reset all specific tracing configuration the to default. If " + TracingConfigurationCommandArg.SCOPE.argName() + " is specified, then remove all label specific configuration for the given scope and reset given scope specific configuration to the default, if " + TracingConfigurationCommandArg.SCOPE.argName() + " is skipped then reset all tracing configurations to the default. Print resulting configuration.", TracingConfigurationSubcommand.RESET_ALL, CommandLogger.optional(TracingConfigurationCommandArg.SCOPE.signature()));
        TracingConfigurationCommand.usageTracing(log, "Reset specific tracing configuration to the default. If both " + TracingConfigurationCommandArg.SCOPE.argName() + " and " + TracingConfigurationCommandArg.LABEL.argName() + " are specified then remove given configuration, if only " + TracingConfigurationCommandArg.SCOPE.argName() + " is specified then reset given configuration to the default. Print resulting configuration.", TracingConfigurationSubcommand.RESET, TracingConfigurationCommandArg.SCOPE.signature(), CommandLogger.optional(TracingConfigurationCommandArg.LABEL.signature()));
        LinkedHashMap setParams = U.newLinkedHashMap((int)4);
        setParams.put(TracingConfigurationCommandArg.SCOPE.signature(), "Scope of a trace's root span to which provided configuration will be applied.");
        setParams.put(TracingConfigurationCommandArg.LABEL.signature(), "Label of a traced operations");
        setParams.put(TracingConfigurationCommandArg.SAMPLING_RATE.signature(), "Decimal value between 0 and 1.0, where 0 means never and 1.0 means always. More or less reflects the probability of sampling specific trace. Default value is 0");
        setParams.put(TracingConfigurationCommandArg.INCLUDED_SCOPES.signature(), "Set of scopes that defines which sub-traces will be included in given trace. In other words, if child's span scope is equals to parent's scope or it belongs to the parent's span included scopes, then given child span will be attached to the current trace, otherwise it'll be skipped.");
        TracingConfigurationCommand.usageTracing(log, TracingConfigurationSubcommand.SET, "Comma separated set new tracing configuration. If both " + TracingConfigurationCommandArg.SCOPE.argName() + " and " + TracingConfigurationCommandArg.LABEL.argName() + " are specified then add or override label specific configuration, if only " + TracingConfigurationCommandArg.SCOPE.argName() + " is specified, then override scope specific configuration. Print applied configuration.", setParams, TracingConfigurationCommandArg.SCOPE.signature(), CommandLogger.optional(TracingConfigurationCommandArg.LABEL.signature()), CommandLogger.optional(TracingConfigurationCommandArg.SAMPLING_RATE.signature()), CommandLogger.optional(TracingConfigurationCommandArg.INCLUDED_SCOPES.signature()));
        log.info("");
    }

    protected static void usageTracing(Logger logger, TracingConfigurationSubcommand cmd, String description, Map<String, String> paramsDesc, String ... args) {
        logger.info("");
        logger.info("  " + CommandLogger.join(" ", new Serializable[]{CommandList.TRACING_CONFIGURATION, cmd != null ? cmd.text() : "", CommandLogger.join(" ", args)}));
        logger.info("    " + description);
        if (!F.isEmpty(paramsDesc)) {
            logger.info("");
            logger.info("    Parameters:");
            Command.usageParams(paramsDesc, "      ", logger);
        }
    }

    protected static void usageTracing(Logger logger, String description, TracingConfigurationSubcommand cmd, String ... args) {
        TracingConfigurationCommand.usageTracing(logger, cmd, description, null, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        if (!this.experimentalEnabled()) {
            log.warning(String.format("For use experimental command add %s=true to JVM_OPTS in %s", "IGNITE_ENABLE_EXPERIMENTAL_COMMAND", "control.(sh|bat)"));
            return null;
        }
        if (TracingConfigurationSubcommand.HELP.equals((Object)this.args.command())) {
            this.printVerboseUsage(log);
            return null;
        }
        try (GridClient client = Command.startClient(clientCfg);){
            UUID crdId = TopologyUtils.coordinatorId(client.compute());
            VisorTracingConfigurationTaskResult res = (VisorTracingConfigurationTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorTracingConfigurationTask.class.getName(), this.toVisorArguments(this.args), crdId, clientCfg);
            this.printResult(res, log::info);
            VisorTracingConfigurationTaskResult visorTracingConfigurationTaskResult = res;
            return visorTracingConfigurationTaskResult;
        }
        catch (Throwable e) {
            log.severe("Failed to execute tracing-configuration command='" + this.args.command().text() + "'");
            throw e;
        }
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            this.args = new TracingConfigurationArguments.Builder(TracingConfigurationSubcommand.GET_ALL).build();
            return;
        }
        String cmdString = argIter.nextArg("Expected tracing configuration action.");
        if ("help".equalsIgnoreCase(cmdString) || "--help".equalsIgnoreCase(cmdString)) {
            this.args = new TracingConfigurationArguments.Builder(TracingConfigurationSubcommand.HELP).build();
            return;
        }
        TracingConfigurationSubcommand cmd = TracingConfigurationSubcommand.of(cmdString);
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct tracing configuration action.");
        }
        TracingConfigurationArguments.Builder tracingConfigurationArgs = new TracingConfigurationArguments.Builder(cmd);
        Scope scope = null;
        String lb = null;
        double samplingRate = 0.0;
        HashSet<Scope> includedScopes = new HashSet<Scope>();
        block17: while (argIter.hasNextSubArg()) {
            TracingConfigurationCommandArg arg = CommandArgUtils.ofArg(TracingConfigurationCommandArg.class, argIter.nextArg(""));
            assert (arg != null);
            switch (arg) {
                case SCOPE: {
                    String peekedNextArg = argIter.peekNextArg();
                    if (TracingConfigurationCommandArg.args().contains(peekedNextArg)) break;
                    String strVal = argIter.nextArg("The scope should be specified. The following values can be used: " + Arrays.toString(Scope.values()) + '.');
                    try {
                        scope = Scope.valueOf((String)strVal.toUpperCase());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Invalid scope '" + strVal + "'. The following values can be used: " + Arrays.toString(Scope.values()) + '.');
                    }
                }
                case LABEL: {
                    lb = argIter.nextArg("The label should be specified.");
                    break;
                }
                case SAMPLING_RATE: {
                    String strVal = argIter.nextArg("The sampling rate should be specified. Decimal value between 0 and 1 should be used.");
                    try {
                        samplingRate = Double.parseDouble(strVal);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Invalid sampling-rate '" + strVal + "'. Decimal value between 0 and 1 should be used.");
                    }
                    if (!(samplingRate < 0.0) && !(samplingRate > 1.0)) break;
                    throw new IllegalArgumentException("Invalid sampling-rate '" + strVal + "'. Decimal value between 0 and 1 should be used.");
                }
                case INCLUDED_SCOPES: {
                    Set<String> setStrVals = argIter.nextStringSet("At least one supported scope should be specified.");
                    for (String scopeStrVal : setStrVals) {
                        try {
                            includedScopes.add(Scope.valueOf((String)scopeStrVal));
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Invalid supported scope '" + scopeStrVal + "'. The following values can be used: " + Arrays.toString(Scope.values()) + '.');
                        }
                    }
                    continue block17;
                }
            }
        }
        if (cmd != TracingConfigurationSubcommand.GET_ALL && cmd != TracingConfigurationSubcommand.RESET_ALL && scope == null) {
            throw new IllegalArgumentException("Scope attribute is missing. Following values can be used: " + Arrays.toString(Scope.values()) + '.');
        }
        switch (cmd) {
            case GET_ALL: 
            case RESET_ALL: {
                tracingConfigurationArgs.withScope(scope);
                break;
            }
            case RESET: 
            case GET: {
                tracingConfigurationArgs.withScope(scope).withLabel(lb);
                break;
            }
            case SET: {
                tracingConfigurationArgs.withScope(scope).withLabel(lb).withSamplingRate(samplingRate).withIncludedScopes(includedScopes);
                break;
            }
            default: {
                assert (false) : "Unexpected tracing configuration argument [arg= " + (Object)((Object)cmd) + ']';
                break;
            }
        }
        this.args = tracingConfigurationArgs.build();
    }

    @Override
    public TracingConfigurationArguments arg() {
        return this.args;
    }

    @Override
    public String name() {
        return CommandList.TRACING_CONFIGURATION.toCommandName();
    }

    @Override
    public boolean experimental() {
        return true;
    }

    private void printResult(VisorTracingConfigurationTaskResult res, Consumer<String> printer) {
        res.print(printer);
    }

    private VisorTracingConfigurationTaskArg toVisorArguments(TracingConfigurationArguments args) {
        return new VisorTracingConfigurationTaskArg(args.command().visorBaselineOperation(), args.scope(), args.label(), args.samplingRate(), args.includedScopes());
    }
}

