/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.lang.IgniteBiTuple;

public class TaskExecutor {
    public static final String DFLT_HOST = "127.0.0.1";
    public static final String DFLT_PORT = "11211";
    public static final UUID BROADCAST_UUID = UUID.randomUUID();

    public static <R> R executeTaskByNameOnNode(GridClient client, String taskClsName, Object taskArgs, UUID nodeId, GridClientConfiguration clientCfg) throws GridClientException {
        GridClientCompute compute = client.compute();
        if (nodeId == BROADCAST_UUID) {
            Collection nodes = compute.nodes(GridClientNode::connectable);
            if (F.isEmpty((Collection)nodes)) {
                throw new GridClientDisconnectedException("Connectable nodes not found", null);
            }
            List nodeIds = nodes.stream().map(GridClientNode::nodeId).collect(Collectors.toList());
            return (R)client.compute().execute(taskClsName, (Object)new VisorTaskArgument(nodeIds, taskArgs, false));
        }
        GridClientNode node = null;
        if (nodeId == null) {
            String cfgAddr = (String)clientCfg.getServers().iterator().next();
            String[] parts = cfgAddr.split(":");
            if (DFLT_HOST.equals(parts[0])) {
                InetAddress addr;
                try {
                    addr = IgniteUtils.getLocalHost();
                }
                catch (IOException e) {
                    throw new GridClientException("Can't get localhost name.", (Throwable)e);
                }
                if (addr.isLoopbackAddress()) {
                    throw new GridClientException("Can't find localhost name.");
                }
                String origAddr = addr.getHostName() + ":" + parts[1];
                node = TaskExecutor.listHosts(client).filter(tuple -> origAddr.equals(tuple.get2())).findFirst().map(IgniteBiTuple::get1).orElse(null);
                if (node == null) {
                    node = TaskExecutor.listHostsByClientNode(client).filter(tuple -> ((List)tuple.get2()).size() == 1 && cfgAddr.equals(((List)tuple.get2()).get(0))).findFirst().map(IgniteBiTuple::get1).orElse(null);
                }
            } else {
                node = TaskExecutor.listHosts(client).filter(tuple -> cfgAddr.equals(tuple.get2())).findFirst().map(IgniteBiTuple::get1).orElse(null);
            }
            if (node == null) {
                node = TaskExecutor.getBalancedNode(compute);
            }
        } else {
            for (GridClientNode n : compute.nodes()) {
                if (!n.connectable() || !nodeId.equals(n.nodeId())) continue;
                node = n;
                break;
            }
            if (node == null) {
                throw new IllegalArgumentException("Node with id=" + nodeId + " not found");
            }
        }
        return (R)compute.projection(node).execute(taskClsName, (Object)new VisorTaskArgument(node.nodeId(), taskArgs, false));
    }

    public static <R> R executeTask(GridClient client, Class<? extends ComputeTask<?, R>> taskCls, Object taskArgs, GridClientConfiguration clientCfg) throws GridClientException {
        return TaskExecutor.executeTaskByNameOnNode(client, taskCls.getName(), taskArgs, null, clientCfg);
    }

    private static Stream<IgniteBiTuple<GridClientNode, String>> listHosts(GridClient client) throws GridClientException {
        return client.compute().nodes(GridClientNode::connectable).stream().flatMap(node -> Stream.concat(node.tcpAddresses() == null ? Stream.empty() : node.tcpAddresses().stream(), node.tcpHostNames() == null ? Stream.empty() : node.tcpHostNames().stream()).map(addr -> new IgniteBiTuple(node, (Object)(addr + ":" + node.tcpPort()))));
    }

    private static Stream<IgniteBiTuple<GridClientNode, List<String>>> listHostsByClientNode(GridClient client) throws GridClientException {
        return client.compute().nodes(GridClientNode::connectable).stream().map(node -> new IgniteBiTuple(node, Stream.concat(node.tcpAddresses() == null ? Stream.empty() : node.tcpAddresses().stream(), node.tcpHostNames() == null ? Stream.empty() : node.tcpHostNames().stream()).map(addr -> addr + ":" + node.tcpPort()).collect(Collectors.toList())));
    }

    private static GridClientNode getBalancedNode(GridClientCompute compute) throws GridClientException {
        Collection nodes = compute.nodes(GridClientNode::connectable);
        if (F.isEmpty((Collection)nodes)) {
            throw new GridClientDisconnectedException("Connectable node not found", null);
        }
        return compute.balancer().balancedNode(nodes);
    }
}

