/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.ignite.internal.util.GridStringBuilder;

public class StringBuilderOutputStream
extends OutputStream {
    private final GridStringBuilder sb;
    protected final Charset encoding;

    public StringBuilderOutputStream() {
        this(new GridStringBuilder(), Charset.forName("UTF-8"));
    }

    public StringBuilderOutputStream(GridStringBuilder sb) {
        this(sb, Charset.forName("UTF-8"));
    }

    public StringBuilderOutputStream(GridStringBuilder sb, Charset encoding) {
        this.sb = sb;
        this.encoding = encoding;
    }

    @Override
    public void write(int b) {
        this.sb.a((char)b);
    }

    @Override
    public void write(byte[] b) {
        this.sb.a(new String(b, this.encoding));
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.sb.a(new String(b, off, len, this.encoding));
    }

    public String toString() {
        return this.sb.toString();
    }
}

