/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.client.ClientCacheConfiguration;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class GridCommandHandlerMetadataTest
extends GridCommandHandlerClusterByClassAbstractTest {
    public static final FileSystem FS = FileSystems.getDefault();
    private static final int TYPES_CNT = 10;

    @Before
    public void init() {
        this.injectTestSystemOut();
    }

    @After
    public void clear() {
        crd.binary().types().stream().forEach(type -> crd.context().cacheObjects().removeType(type.typeId()));
    }

    @Test
    public void testMetadataList() {
        for (int typeNum = 0; typeNum < 10; ++typeNum) {
            BinaryObjectBuilder bob = crd.binary().builder("Type_" + typeNum);
            for (int fldNum = 0; fldNum <= typeNum; ++fldNum) {
                bob.setField("fld_" + fldNum, (Object)0);
            }
            bob.build();
        }
        GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
        String out = testOut.toString();
        for (int typeNum = 0; typeNum < 10; ++typeNum) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("typeName=Type_" + typeNum));
        }
    }

    @Test
    public void testMetadataRemoveWrongType() {
        this.injectTestSystemOut();
        String wrongTypeName = "Type01";
        GridCommandHandlerMetadataTest.assertEquals((int)1, (int)this.execute("--meta", "remove", "--typeName", wrongTypeName));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)("Failed to remove binary type, type not found: " + wrongTypeName));
        int wrongTypeId = 42;
        GridCommandHandlerMetadataTest.assertEquals((int)1, (int)this.execute("--meta", "remove", "--typeId", Integer.toString(wrongTypeId)));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Failed to remove binary type, type not found: ");
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)("0x" + Integer.toHexString(wrongTypeId).toUpperCase() + " (" + wrongTypeId + ")"));
    }

    @Test
    public void testMetadataForInternalClassesIsNotRegistered() {
        this.injectTestSystemOut();
        IgniteCache dfltCache = this.grid(0).getOrCreateCache("default");
        dfltCache.put((Object)1, (Object)new TestValue());
        Collection metadata = crd.context().cacheObjects().metadata();
        GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
        GridCommandHandlerMetadataTest.assertEquals((String)metadata.toString(), (int)1, (int)metadata.size());
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)("typeName=" + TestValue.class.getTypeName()));
        this.grid(0).destroyCache("default");
        metadata = crd.context().cacheObjects().metadata();
        GridCommandHandlerMetadataTest.assertEquals((String)metadata.toString(), (int)1, (int)metadata.size());
        GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", TestValue.class.getTypeName()));
        metadata = crd.context().cacheObjects().metadata();
        GridCommandHandlerMetadataTest.assertEquals((String)("Binary metadata is expected to be empty but the following binary types were found: " + metadata.stream().map(b -> "BinaryType[typeId=" + b.typeId() + ", typeName=" + b.typeName() + ']').collect(Collectors.toList()).toString()), (int)0, (int)metadata.size());
    }

    @Test
    public void testMetadataDetails() {
        BinaryObjectBuilder bob0 = crd.binary().builder("TypeName0");
        bob0.setField("fld0", (Object)0);
        bob0.build();
        bob0 = crd.binary().builder("TypeName0");
        bob0.setField("fld1", (Object)"0");
        bob0.build();
        bob0 = crd.binary().builder("TypeName0");
        bob0.setField("fld0", (Object)1);
        bob0.setField("fld2", (Object)UUID.randomUUID());
        BinaryObject bo0 = bob0.build();
        BinaryObjectBuilder bob1 = crd.binary().builder("TypeName1");
        bob1.setField("fld0", (Object)0);
        bob1.build();
        bob1 = crd.binary().builder("TypeName1");
        bob1.setField("fld0", (Object)0);
        bob1.setField("fld1", (Object)new Date());
        bob1.setField("fld2", (Object)0.1);
        bob1.setField("fld3", (Object)new long[]{0L, 1L, 2L, 3L});
        BinaryObject bo1 = bob1.build();
        GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "details", "--typeName", "TypeName0"));
        this.checkTypeDetails(log, testOut.toString(), crd.context().cacheObjects().metadata(bo0.type().typeId()));
        GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "details", "--typeId", "0x" + Integer.toHexString(crd.context().cacheObjects().typeId("TypeName1"))));
        this.checkTypeDetails(log, testOut.toString(), crd.context().cacheObjects().metadata(bo1.type().typeId()));
        GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "details", "--typeId", Integer.toString(crd.context().cacheObjects().typeId("TypeName1"))));
        this.checkTypeDetails(log, testOut.toString(), crd.context().cacheObjects().metadata(bo1.type().typeId()));
    }

    @Test
    public void testInvalidArguments() throws Exception {
        String inDirName = Files.createTempDirectory(((Object)((Object)this)).getClass().getSimpleName() + " _inDir_" + UUID.randomUUID(), new FileAttribute[0]).toFile().getAbsolutePath();
        String outDirName = Files.createTempDirectory(((Object)((Object)this)).getClass().getSimpleName() + " _outDir_" + UUID.randomUUID(), new FileAttribute[0]).toFile().getAbsolutePath();
        GridCommandHandlerMetadataTest.assertEquals((int)1, (int)this.execute("--meta", "remove"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Check arguments.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Type to remove is not specified");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Please add one of the options: --typeName <type_name> or --typeId <type_id>");
        GridCommandHandlerMetadataTest.assertEquals((int)1, (int)this.execute("--meta", "remove", "--typeId", "0", "--out", outDirName));
        out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Check arguments.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Cannot write to output file " + outDirName));
        GridCommandHandlerMetadataTest.assertEquals((int)1, (int)this.execute("--meta", "update", "--in", inDirName));
        out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Check arguments.");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Cannot read metadata from " + inDirName));
    }

    @Test
    public void testRemoveUpdate() throws Exception {
        Path typeFile = FS.getPath("type0.bin", new String[0]);
        try {
            this.createType("Type0", 0);
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
                this.createType("Type0", "string");
                return null;
            }, BinaryObjectException.class, (String)"Wrong value has been set");
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", "Type0", "--out", typeFile.toString()));
            this.createType("Type0", "string");
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", "Type0"));
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "update", "--in", typeFile.toString()));
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
                this.createType("Type0", "string");
                return null;
            }, BinaryObjectException.class, (String)"Wrong value has been set");
            this.createType("Type0", 1);
            crd.context().cacheObjects().removeType(crd.context().cacheObjects().typeId("Type0"));
            this.createType("Type0", "string");
            GridCommandHandlerMetadataTest.assertEquals((int)4, (int)this.execute("--meta", "update", "--in", typeFile.toString()));
            String out = testOut.toString();
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Failed to execute metadata command='update'");
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Type 'Type0' with typeId 110843958 has a different/incorrect type for field 'fld'.");
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Expected 'String' but 'int' was provided. The type of an existing field can not be changed");
        }
        finally {
            if (Files.exists(typeFile, new LinkOption[0])) {
                Files.delete(typeFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropThinConnectionsOnRemove() throws Exception {
        Path typeFile = FS.getPath("type0.bin", new String[0]);
        try (IgniteClient cli = Ignition.startClient((ClientConfiguration)this.clientConfiguration());){
            this.createType(cli.binary(), "Type0", 1);
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", "Type0", "--out", typeFile.toString()));
            GridTestUtils.assertThrows((IgniteLogger)log, () -> cli.createCache(new ClientCacheConfiguration().setName("test")), Exception.class, null);
            this.createType(cli.binary(), "Type0", "str");
        }
        finally {
            if (Files.exists(typeFile, new LinkOption[0])) {
                Files.delete(typeFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropJdbcThinConnectionsOnRemove() throws Exception {
        Path typeFile = FS.getPath("type0.bin", new String[0]);
        try (Connection conn = DriverManager.getConnection(this.jdbcThinUrl());){
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE test(id INT PRIMARY KEY, objVal OTHER)");
                try (PreparedStatement pstmt = conn.prepareStatement("INSERT INTO test(id, objVal) VALUES (?, ?)");){
                    pstmt.setInt(1, 0);
                    pstmt.setObject(2, new TestValue());
                    pstmt.execute();
                }
                stmt.execute("DELETE FROM test WHERE id >= 0");
            }
            HashMap metasOld = (HashMap)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"metaHnd", "cache", "metas"});
            GridCommandHandlerMetadataTest.assertFalse((boolean)metasOld.isEmpty());
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", TestValue.class.getName(), "--out", typeFile.toString()));
            try (Statement stmt = conn.createStatement();){
                stmt.execute("SELECT * FROM test");
            }
            HashMap metas = (HashMap)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"metaHnd", "cache", "metas"});
            GridCommandHandlerMetadataTest.assertNotSame((Object)metasOld, (Object)metas);
            GridCommandHandlerMetadataTest.assertTrue((boolean)metas.isEmpty());
        }
        finally {
            if (Files.exists(typeFile, new LinkOption[0])) {
                Files.delete(typeFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTypeMergedAfterRemoveUpdate() {
        String[] typeNames = new String[]{"TypeName0", "TypeName1"};
        int cnt = typeNames.length;
        Object[] typeValues = new Object[]{0, LocalDate.now()};
        int[] typeIds = new int[cnt];
        this.repeat(cnt, i -> {
            typeIds[i.intValue()] = crd.binary().builder(typeNames[i]).setField("fld0", typeValues[i]).build().type().typeId();
        });
        Path[] typeBackups = new Path[typeNames.length];
        try {
            this.repeat(cnt, i -> {
                Path path;
                typeBackups[i.intValue()] = path = FS.getPath(typeNames[i] + ".bin", new String[0]);
                GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", typeNames[i], "--out", path.toString()));
            });
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
            String out = testOut.toString();
            this.repeat(cnt, i -> GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)("typeName=" + typeNames[i])));
            this.repeat(cnt, i -> crd.binary().builder(typeNames[i]).setField("fld1", typeValues[i]).build());
            this.repeat(cnt, i -> GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "update", "--in", typeBackups[i].toString())));
            this.repeat(cnt, i -> {
                GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "details", "--typeName", typeNames[i]));
                this.checkTypeDetails(log, testOut.toString(), crd.context().cacheObjects().metadata(typeIds[i]));
            });
        }
        finally {
            this.repeat(cnt, i -> {
                if (typeBackups[i] != null) {
                    try {
                        Files.deleteIfExists(typeBackups[i]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTypeCantBeMergedAfterRemoveUpdateWithIncompatibleChanges() {
        String[] typeNames = new String[]{"TypeName0", "TypeName1"};
        int cnt = typeNames.length;
        Object[] typeValues = new Object[]{0, LocalDate.now()};
        this.repeat(cnt, i -> crd.binary().builder(typeNames[i]).setField("fld0", typeValues[i]).build().type().typeId());
        Path[] typeBackups = new Path[typeNames.length];
        try {
            this.repeat(cnt, i -> {
                Path path;
                typeBackups[i.intValue()] = path = FS.getPath(typeNames[i] + ".bin", new String[0]);
                GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", typeNames[i], "--out", path.toString()));
            });
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
            String out = testOut.toString();
            this.repeat(cnt, i -> GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)("typeName=" + typeNames[i])));
            this.repeat(cnt, i -> crd.binary().builder(typeNames[i]).setField("fld0", typeValues[cnt - i - 1]).build());
            this.repeat(cnt, i -> {
                GridCommandHandlerMetadataTest.assertEquals((int)4, (int)this.execute("--meta", "update", "--in", typeBackups[i].toString()));
                GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"The type of an existing field can not be changed");
            });
        }
        finally {
            this.repeat(cnt, i -> {
                if (typeBackups[i] != null) {
                    try {
                        Files.deleteIfExists(typeBackups[i]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveUpdateUnderLoad() throws Exception {
        Path typeFile = FS.getPath("type0.bin", new String[0]);
        try {
            this.createType("Type0", 0);
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"typeName=Type0");
            AtomicBoolean stop = new AtomicBoolean(false);
            Thread t = new Thread(() -> {
                long i = 1L;
                while (!stop.get()) {
                    this.createType("Type" + i++, i);
                }
            });
            t.start();
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", "Type0", "--out", typeFile.toString()));
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)"typeName=Type0");
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "update", "--in", typeFile.toString()));
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"typeName=Type0");
            stop.set(true);
            t.join(this.getTestTimeout());
        }
        finally {
            if (Files.exists(typeFile, new LinkOption[0])) {
                Files.delete(typeFile);
            }
        }
    }

    @Test
    public void testMetadataListDetailsAfterTypeRemoving() throws IOException {
        Path typeFile = FS.getPath("type0.bin", new String[0]);
        try {
            int typeId = this.createType("Type0", 0);
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"typeName=Type0");
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "details", "--typeName", "Type0"));
            this.checkTypeDetails(log, testOut.toString(), crd.binary().type(typeId));
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "remove", "--typeName", "Type0", "--out", typeFile.toString()));
            GridCommandHandlerMetadataTest.assertEquals((int)0, (int)this.execute("--meta", "list"));
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)"typeName=Type0");
            GridCommandHandlerMetadataTest.assertEquals((int)4, (int)this.execute("--meta", "details", "--typeName", "Type0"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)("type not found: " + typeId));
        }
        finally {
            Files.deleteIfExists(typeFile);
        }
    }

    private void repeat(int cnt, Consumer<Integer> cons) {
        for (int i = 0; i < cnt; ++i) {
            cons.accept(i);
        }
    }

    private void checkTypeDetails(@Nullable IgniteLogger log, String cmdOut, BinaryType t) {
        GridTestUtils.assertContains((IgniteLogger)log, (String)cmdOut, (String)("typeId=0x" + Integer.toHexString(t.typeId()).toUpperCase()));
        GridTestUtils.assertContains((IgniteLogger)log, (String)cmdOut, (String)("typeName=" + t.typeName()));
        GridTestUtils.assertContains((IgniteLogger)log, (String)cmdOut, (String)"Fields:");
        for (String fldName : t.fieldNames()) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)cmdOut, (String)("name=" + fldName + ", type=" + t.fieldTypeName(fldName)));
        }
        for (BinarySchema s : ((BinaryTypeImpl)t).metadata().schemas()) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)cmdOut, (String)("schemaId=0x" + Integer.toHexString(s.schemaId()).toUpperCase()));
        }
    }

    int createType(String typeName, Object val) {
        return this.createType(crd.binary(), typeName, val);
    }

    int createType(IgniteBinary bin, String typeName, Object val) {
        return bin.builder(typeName).setField("fld", val).build().type().typeId();
    }

    protected ClientConfiguration clientConfiguration() {
        return new ClientConfiguration().setAddressesFinder(() -> new String[]{"127.0.0.1:10800"}).setAffinityAwarenessEnabled(false);
    }

    protected String jdbcThinUrl() {
        return "jdbc:ignite:thin://127.0.0.1";
    }

    public static class TestValue {
        public final int val = 3;
    }
}

