/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.TestStorageUtils;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.AtomicConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.OutputFormat;
import org.apache.ignite.internal.commandline.baseline.BaselineSubcommands;
import org.apache.ignite.internal.commandline.cache.CacheCommandList;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.PartitionReconciliationCommandArg;
import org.apache.ignite.internal.commandline.tracing.configuration.TracingConfigurationSubcommand;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKeyImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionRollbackException;
import org.apache.ignite.transactions.TransactionState;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="true"), @WithSystemProperty(key="IGNITE_CLUSTER_ID_AND_TAG_FEATURE", value="true")})
public class GridCommandHandlerClusterByClassTest
extends GridCommandHandlerClusterByClassAbstractTest {
    private static final String ANY = "<!any!>";
    protected static final String ERROR_STACK_TRACE_PREFIX = "Error stack trace:";

    @Test
    public void testFindAndDeleteGarbage() {
        IgniteEx ignite = crd;
        this.injectTestSystemOut();
        ignite.createCaches(Arrays.asList(new CacheConfiguration("garbage1").setGroupName("groupGarbage"), new CacheConfiguration("garbage2").setGroupName("groupGarbage")));
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "find_garbage", "--port", "11212"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"garbage not found");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "find_garbage", this.ignite(0).localNode().id().toString(), "--port", "11212"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"garbage not found");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "find_garbage", "groupGarbage", "--port", "11212"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"garbage not found");
    }

    @Test
    public void testBaselineAutoAdjustmentSettings() {
        IgniteEx ignite = crd;
        IgniteClusterEx cl = ignite.cluster();
        GridCommandHandlerClusterByClassTest.assertFalse((boolean)cl.isBaselineAutoAdjustEnabled());
        long timeout = cl.baselineAutoAdjustTimeout();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", Long.toString(timeout + 1L)));
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)cl.isBaselineAutoAdjustEnabled());
        GridCommandHandlerClusterByClassTest.assertEquals((long)(timeout + 1L), (long)cl.baselineAutoAdjustTimeout());
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "disable"));
        GridCommandHandlerClusterByClassTest.assertFalse((boolean)cl.isBaselineAutoAdjustEnabled());
        GridCommandHandlerClusterByClassTest.assertEquals((long)(timeout + 1L), (long)cl.baselineAutoAdjustTimeout());
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust"));
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "true"));
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "enable", "x"));
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--baseline", "auto_adjust", "disable", "x"));
    }

    @Test
    public void shouldReturnErrorCodeForManualSetInBaselineAutoAdjustmentEnable() {
        IgniteEx ignite = crd;
        IgniteClusterEx cl = ignite.cluster();
        long timeout = cl.baselineAutoAdjustTimeout();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--baseline", "auto_adjust", "enable", "timeout", Long.toString(timeout + 1L)));
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)cl.isBaselineAutoAdjustEnabled());
        GridCommandHandlerClusterByClassTest.assertEquals((int)5, (int)this.execute("--baseline", "version", "1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionInfo() throws Exception {
        client.getOrCreateCache(new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(1).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC));
        for (Ignite ig : G.allGrids()) {
            GridCommandHandlerClusterByClassTest.assertNotNull((Object)ig.cache("default"));
        }
        CountDownLatch lockLatch = new CountDownLatch(1);
        CountDownLatch unlockLatch = new CountDownLatch(1);
        IgniteInternalFuture<?> fut = this.startTransactions("testTransactionInfo", lockLatch, unlockLatch, false);
        try {
            U.awaitQuiet((CountDownLatch)lockLatch);
            GridCommandHandlerClusterByClassTest.doSleep((long)3000L);
            HashSet<GridCacheVersion> nearXids = new HashSet<GridCacheVersion>();
            for (int i = 0; i < 2; ++i) {
                IgniteEx grid = this.grid(i);
                IgniteTxManager tm = grid.context().cache().context().tm();
                for (IgniteInternalTx tx : tm.activeTransactions()) {
                    nearXids.add(tx.nearXidVersion());
                }
            }
            this.injectTestSystemOut();
            for (GridCacheVersion nearXid : nearXids) {
                GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--tx", "--info", nearXid.toString()));
                String out = testOut.toString();
                GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)nearXid.toString());
            }
        }
        finally {
            unlockLatch.countDown();
            fut.get();
        }
    }

    @Test
    public void testTransactionHistoryInfo() throws Exception {
        client.getOrCreateCache(new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(2).setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC));
        for (Ignite ig : G.allGrids()) {
            GridCommandHandlerClusterByClassTest.assertNotNull((Object)ig.cache("default"));
        }
        CountDownLatch lockLatch = new CountDownLatch(1);
        CountDownLatch unlockLatch = new CountDownLatch(1);
        IgniteInternalFuture<?> fut = this.startTransactions("testTransactionHistoryInfo", lockLatch, unlockLatch, false);
        U.awaitQuiet((CountDownLatch)lockLatch);
        GridCommandHandlerClusterByClassTest.doSleep((long)3000L);
        HashSet<GridCacheVersion> nearXids = new HashSet<GridCacheVersion>();
        for (int i = 0; i < 2; ++i) {
            IgniteEx grid = this.grid(i);
            IgniteTxManager tm = grid.context().cache().context().tm();
            for (IgniteInternalTx tx : tm.activeTransactions()) {
                nearXids.add(tx.nearXidVersion());
            }
        }
        unlockLatch.countDown();
        fut.get();
        GridCommandHandlerClusterByClassTest.doSleep((long)3000L);
        this.injectTestSystemOut();
        boolean commitMatched = false;
        boolean rollbackMatched = false;
        for (GridCacheVersion nearXid : nearXids) {
            GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--tx", "--info", nearXid.toString()));
            String out = testOut.toString();
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Transaction was found in completed versions history of the following nodes:");
            if (out.contains(TransactionState.COMMITTED.name())) {
                commitMatched = true;
                GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)TransactionState.ROLLED_BACK.name());
            }
            if (!out.contains(TransactionState.ROLLED_BACK.name())) continue;
            rollbackMatched = true;
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)TransactionState.COMMITTED.name());
        }
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)commitMatched);
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)rollbackMatched);
    }

    @Test
    public void testCacheHelp() throws Exception {
        HashSet<String> skippedCommands = new HashSet<String>();
        skippedCommands.add(PartitionReconciliationCommandArg.RECHECK_DELAY.toString());
        skippedCommands.add(PartitionReconciliationCommandArg.LOCAL_OUTPUT.toString());
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "help"));
        String output = testOut.toString();
        for (CacheSubcommands cmd : CacheSubcommands.values()) {
            if (cmd != CacheSubcommands.HELP) {
                GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)cmd.toString());
                Class args = cmd.getCommandArgs();
                if (args == null) continue;
                for (Enum arg : (Enum[])args.getEnumConstants()) {
                    if (skippedCommands.contains(arg.toString())) continue;
                    GridCommandHandlerClusterByClassTest.assertTrue((String)(cmd + " " + arg), (boolean)output.contains(arg.toString()));
                }
                continue;
            }
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)"control.(sh|bat)");
        }
        this.checkHelp(output, "org.apache.ignite.util/" + ((Object)((Object)this)).getClass().getSimpleName() + "_cache_help.output");
    }

    @Test
    public void testTracingHelp() throws Exception {
        HashSet<TracingConfigurationSubcommand> skippedCommands = new HashSet<TracingConfigurationSubcommand>();
        skippedCommands.add(TracingConfigurationSubcommand.HELP);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--tracing-configuration", "help"));
        String output = testOut.toString();
        for (TracingConfigurationSubcommand cmd : TracingConfigurationSubcommand.values()) {
            if (skippedCommands.contains(cmd)) continue;
            GridTestUtils.assertContains((IgniteLogger)log, (String)output, (String)cmd.toString());
        }
        this.checkHelp(output, "org.apache.ignite.util/" + ((Object)((Object)this)).getClass().getSimpleName() + "_tracing_help.output");
    }

    @Test
    public void testCorrectCacheCmdOptionsNaming() {
        String cmdName;
        Pattern cmdNamePtrn = Pattern.compile("([a-z]+(_)?)+");
        Pattern opNamePtrn = Pattern.compile("^--([a-z]+(-)?)+([a-z]+)");
        for (CacheSubcommands cacheSubcommands : CacheSubcommands.values()) {
            cmdName = cacheSubcommands.toString();
            GridCommandHandlerClusterByClassTest.assertTrue((String)cmdName, (boolean)cmdNamePtrn.matcher(cmdName).matches());
            Class args = cacheSubcommands.getCommandArgs();
            if (Objects.isNull(args)) continue;
            for (Enum arg : (Enum[])args.getEnumConstants()) {
                String opName = arg.toString();
                GridCommandHandlerClusterByClassTest.assertTrue((String)(cmdName + " " + opName), (boolean)opNamePtrn.matcher(opName).matches());
            }
        }
        for (CacheSubcommands cacheSubcommands : CacheCommandList.values()) {
            cmdName = cacheSubcommands.toString();
            GridCommandHandlerClusterByClassTest.assertTrue((String)cmdName, (boolean)cmdNamePtrn.matcher(cmdName).matches());
        }
    }

    @Test
    public void testHelp() throws Exception {
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--help"));
        String testOutStr = testOut.toString();
        for (CommandList cmd : CommandList.values()) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOutStr, (String)cmd.toString());
        }
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOutStr, (String)"Control.sh");
        this.checkHelp(testOutStr, "org.apache.ignite.util/" + ((Object)((Object)this)).getClass().getSimpleName() + "_help.output");
    }

    private void checkHelp(String output, String resourceName) throws Exception {
        String correctOutput = new String(GridTestUtils.readResource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resourceName));
        try {
            List correctOutputLines = U.sealList((Object[])correctOutput.split("\\r?\\n"));
            List outputLines = U.sealList((Object[])output.split("\\r?\\n"));
            GridCommandHandlerClusterByClassTest.assertEquals((String)("Wrong number of lines! Golden copy resource: " + resourceName), (int)correctOutputLines.size(), (int)outputLines.size());
            for (int i = 0; i < correctOutputLines.size(); ++i) {
                String cLine = (String)correctOutputLines.get(i);
                String line = ((String)outputLines.get(i)).replaceAll("\\s+$", "");
                if (cLine.contains(ANY)) {
                    String[] lineChunks = line.split("\\s");
                    String[] cLineChunks = cLine.split("\\s");
                    GridCommandHandlerClusterByClassTest.assertTrue((String)("line: " + i + ", wrong words count"), (lineChunks.length == cLineChunks.length ? 1 : 0) != 0);
                    for (int j = 0; j < cLineChunks.length; ++j) {
                        String cLineChunk = cLineChunks[j];
                        if (cLineChunk.equals(ANY)) continue;
                        GridCommandHandlerClusterByClassTest.assertTrue((String)("line: " + i), (boolean)lineChunks[j].equals(cLineChunk));
                    }
                    continue;
                }
                GridCommandHandlerClusterByClassTest.assertEquals((String)("line: " + i), (String)cLine, (String)line);
            }
        }
        catch (AssertionError e) {
            log.info("Correct output is: " + correctOutput);
            throw e;
        }
    }

    @Test
    public void testOldReadOnlyApiNotAvailable() {
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--read-only-on"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Check arguments. Unexpected argument: --read-only-on");
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--read-only-off"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Check arguments. Unexpected argument: --read-only-off");
    }

    @Test
    public void testPrintTimestampAtEndsOfExecution() {
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute(new String[0]));
        String testOutStr = testOut.toString();
        GridTestUtils.assertMatches((IgniteLogger)log, (String)testOutStr, (String)"Time: [0-9]{4}-(((0[13578]|(10|12))-(0[1-9]|[1-2][0-9]|3[0-1]))|(02-(0[1-9]|[1-2][0-9]))|((0[469]|11)-(0[1-9]|[1-2][0-9]|30)))T(20|21|22|23|[01]\\d|\\d)((:[0-5]\\d){1,2})\\.\\d{3}");
        GridTestUtils.assertMatches((IgniteLogger)log, (String)testOutStr, (String)"Control utility has completed execution at: [0-9]{4}-(((0[13578]|(10|12))-(0[1-9]|[1-2][0-9]|3[0-1]))|(02-(0[1-9]|[1-2][0-9]))|((0[469]|11)-(0[1-9]|[1-2][0-9]|30)))T(20|21|22|23|[01]\\d|\\d)((:[0-5]\\d){1,2})\\.\\d{3}");
        GridTestUtils.assertMatches((IgniteLogger)log, (String)testOutStr, (String)"Execution time: \\d+ ms");
    }

    @Test
    public void testCacheIdleVerify() {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no conflicts have been found");
        HashSet<Integer> clearKeys = new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6));
        ignite.context().cache().cache("default").clearLocallyAll(clearKeys, true, true, true);
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"conflict partitions");
    }

    @Test
    public void testCacheIdleVerifyNodeFilter() {
        IgniteEx ignite = crd;
        Object lastNodeCId = ignite.localNode().consistentId();
        ignite.createCache(new CacheConfiguration("default").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setNodeFilter((IgnitePredicate & Serializable)node -> !node.consistentId().equals(lastNodeCId)).setBackups(1));
        try (IgniteDataStreamer streamer = ignite.dataStreamer("default");){
            for (int i = 0; i < 100; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "default"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no conflicts have been found");
    }

    @Test
    public void testCacheIdleVerifyTwoConflictTypes() {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"no conflicts have been found");
        GridCacheContext cacheCtx = ignite.cachex("default").context();
        TestStorageUtils.corruptDataEntry((GridCacheContext)cacheCtx, (Object)1, (boolean)true, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        TestStorageUtils.corruptDataEntry((GridCacheContext)cacheCtx, (Object)(1 + cacheCtx.config().getAffinity().partitions() / 2), (boolean)false, (boolean)true, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"found 2 conflict partitions");
    }

    @Test
    public void testCacheIdleVerifyDumpSkipZerosUpdateCounters() throws Exception {
        IgniteEx ignite = crd;
        int emptyPartId = 31;
        this.createCacheAndPreload((Ignite)ignite, emptyPartId);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--skip-zeros", "default"));
        Matcher fileNameMatcher = this.dumpFileNameMatcher();
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)fileNameMatcher.find());
        String zeroUpdateCntrs = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
        GridTestUtils.assertContains((IgniteLogger)log, (String)zeroUpdateCntrs, (String)("idle_verify check has finished, found " + emptyPartId + " partitions"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)zeroUpdateCntrs, (String)"1 partitions was skipped");
        GridTestUtils.assertContains((IgniteLogger)log, (String)zeroUpdateCntrs, (String)"idle_verify check has finished, no conflicts have been found.");
        this.assertSort(emptyPartId, zeroUpdateCntrs);
        ignite.cache("default").put((Object)emptyPartId, (Object)emptyPartId);
        ignite.cache("default").remove((Object)emptyPartId, (Object)emptyPartId);
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--skip-zeros", "default"));
        fileNameMatcher = this.dumpFileNameMatcher();
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)fileNameMatcher.find());
        String nonZeroUpdateCntrs = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
        GridTestUtils.assertContains((IgniteLogger)log, (String)nonZeroUpdateCntrs, (String)"idle_verify check has finished, found 31 partitions");
        GridTestUtils.assertContains((IgniteLogger)log, (String)nonZeroUpdateCntrs, (String)"1 partitions was skipped");
        GridTestUtils.assertContains((IgniteLogger)log, (String)nonZeroUpdateCntrs, (String)"idle_verify check has finished, no conflicts have been found.");
        this.assertSort(31, zeroUpdateCntrs);
        GridCommandHandlerClusterByClassTest.assertEquals((String)zeroUpdateCntrs, (String)nonZeroUpdateCntrs);
    }

    @Test
    public void testCacheIdleVerifyDump() throws Exception {
        IgniteEx ignite = crd;
        int keysCount = 20;
        this.createCacheAndPreload((Ignite)ignite, keysCount);
        int parts = ignite.affinity("default").partitions();
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setBackups(1).setName("defaultother"));
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "default"));
        Matcher fileNameMatcher = this.dumpFileNameMatcher();
        if (fileNameMatcher.find()) {
            String dumpWithZeros = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithZeros, (String)("idle_verify check has finished, found " + parts + " partitions"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithZeros, (String)"Partition: PartitionKeyV2 [grpId=1544803905, grpName=default, partId=0]");
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithZeros, (String)"updateCntr=0, reserveCntr=0, partitionState=OWNING, size=0, partHash=0");
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithZeros, (String)"no conflicts have been found");
            this.assertSort(parts, dumpWithZeros);
        }
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--skip-zeros", "default"));
        fileNameMatcher = this.dumpFileNameMatcher();
        if (fileNameMatcher.find()) {
            String dumpWithoutZeros = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithoutZeros, (String)("idle_verify check has finished, found " + keysCount + " partitions"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithoutZeros, (String)(parts - keysCount + " partitions was skipped"));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithoutZeros, (String)"Partition: PartitionKeyV2 [grpId=1544803905, grpName=default, partId=");
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)dumpWithoutZeros, (String)"updateCntr=0, partitionState=OWNING, size=0, partHash=0");
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithoutZeros, (String)"no conflicts have been found");
            this.assertSort(keysCount, dumpWithoutZeros);
        } else {
            GridCommandHandlerClusterByClassTest.fail((String)"Should be found both files");
        }
    }

    @Test
    public void testCacheIdleVerifyMultipleCacheFilterOptions() throws Exception {
        IgniteEx ignite = crd;
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setGroupName("shared_grp").setBackups(1).setName("default"));
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setGroupName("shared_grp").setBackups(1).setName("default_second"));
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 64)).setBackups(1).setName("default_third"));
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 128)).setBackups(1).setName("wrong_cache"));
        this.injectTestSystemOut();
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, found", "idle_verify task was executed with the following args: caches=[], excluded=[wrong.*], cacheFilter=[SYSTEM]", "--cache", "idle_verify", "--dump", "--cache-filter", "SYSTEM", "--exclude-caches", "wrong.*");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, found 96 partitions", null, "--cache", "idle_verify", "--dump", "--exclude-caches", "wrong.*");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, found 32 partitions", null, "--cache", "idle_verify", "--dump", "shared.*");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, found 160 partitions", null, "--cache", "idle_verify", "--dump", "shared.*,wrong.*");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, found 160 partitions", null, "--cache", "idle_verify", "--dump", "shared.*,wrong.*", "--cache-filter", "USER");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, found 160 partitions", null, "--cache", "idle_verify", "--dump", "shared.*,wrong.*");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "There are no caches matching given filter options", null, "--cache", "idle_verify", "--exclude-caches", ".*");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(false, "Invalid cache name regexp", null, "--cache", "idle_verify", "--dump", "--exclude-caches", "[");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, no conflicts have been found.", null, "--cache", "idle_verify", "--exclude-caches", "wrong.*");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "idle_verify check has finished, no conflicts have been found.", null, "--cache", "idle_verify", "--dump", "--cache-filter", "PERSISTENT");
        this.testCacheIdleVerifyMultipleCacheFilterOptionsCommon(true, "There are no caches matching given filter options.", null, "--cache", "idle_verify", "--cache-filter", "NOT_PERSISTENT");
    }

    private void testCacheIdleVerifyMultipleCacheFilterOptionsCommon(boolean exitOk, String outputExp, String cmdExp, String ... args) throws IOException {
        HashSet<String> argsSet = new HashSet<String>(Arrays.asList(args));
        int exitCode = this.execute(args);
        GridCommandHandlerClusterByClassTest.assertEquals((String)testOut.toString(), (boolean)exitOk, (0 == exitCode ? 1 : 0) != 0);
        if (exitCode == 0) {
            Matcher fileNameMatcher = this.dumpFileNameMatcher();
            if (fileNameMatcher.find()) {
                GridTestUtils.assertContains((IgniteLogger)log, argsSet, (Object)"--dump");
                Path filePath = Paths.get(fileNameMatcher.group(1), new String[0]);
                String dump = new String(Files.readAllBytes(filePath));
                Files.delete(filePath);
                GridTestUtils.assertContains((IgniteLogger)log, (String)dump, (String)outputExp);
                if (cmdExp != null) {
                    GridTestUtils.assertContains((IgniteLogger)log, (String)dump, (String)cmdExp);
                }
            } else {
                GridTestUtils.assertNotContains((IgniteLogger)log, argsSet, (Object)"--dump");
                GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)outputExp);
            }
        } else {
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)outputExp);
        }
    }

    private void assertSort(int expectedPartsCount, String output) {
        Pattern partIdPattern = Pattern.compile(".*partId=([0-9]*)");
        Pattern primaryPattern = Pattern.compile("Partition instances: \\[PartitionHashRecordV2 \\[isPrimary=true");
        Matcher partIdMatcher = partIdPattern.matcher(output);
        Matcher primaryMatcher = primaryPattern.matcher(output);
        int i = 0;
        while (partIdMatcher.find()) {
            GridCommandHandlerClusterByClassTest.assertEquals((int)i++, (int)Integer.parseInt(partIdMatcher.group(1)));
            GridCommandHandlerClusterByClassTest.assertTrue((boolean)primaryMatcher.find());
        }
        GridCommandHandlerClusterByClassTest.assertEquals((int)expectedPartsCount, (int)i);
    }

    @Test
    public void testCacheIdleVerifyDumpForCorruptedData() throws Exception {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        this.corruptingAndCheckDefaultCache(ignite, "USER", true);
    }

    @Test
    public void testCacheIdleVerifyForCorruptedData() throws Exception {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        this.corruptingAndCheckDefaultCache(ignite, "USER", false);
    }

    @Test
    public void testIdleVerifyShouldFindReserveCounterConflictsOnPrimary() {
        CacheConfiguration cfg = new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(1);
        this.injectTestSystemOut();
        IgniteCache cache = crd.getOrCreateCache(cfg);
        this.breakReserveCounterInvariant((IgniteCache<String, String>)cache, true);
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", cache.getName()));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"found 1 conflict partitions: [updateCounterConflicts=0, reserveCounterConflicts=1, hashConflicts=0]");
    }

    @Test
    public void testIdleVerifyShouldNotFindReserveCounterConflictsOnBackup() {
        CacheConfiguration cfg = new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(1);
        this.injectTestSystemOut();
        IgniteCache cache = crd.getOrCreateCache(cfg);
        this.breakReserveCounterInvariant((IgniteCache<String, String>)cache, false);
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", cache.getName()));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"idle_verify check has finished, no conflicts have been found.");
    }

    public void breakReserveCounterInvariant(IgniteCache<String, String> cache, boolean usePrimaryPartition) {
        String key = "foo";
        cache.put((Object)key, (Object)"bar");
        int partNum = crd.affinity(cache.getName()).partition((Object)key);
        IgniteEx node = (IgniteEx)(usePrimaryPartition ? this.primaryNode(key, cache.getName()) : this.backupNode(key, cache.getName()));
        GridDhtLocalPartition part = node.context().cache().cache(cache.getName()).context().topology().localPartition(partNum);
        PartitionUpdateCounter counter = part.dataStore().partUpdateCounter();
        assert (counter != null);
        if (!usePrimaryPartition) {
            counter.finalizeUpdateCounters();
        }
        counter.reserve(-1L);
        GridCommandHandlerClusterByClassTest.assertTrue((String)"HWM should not be negative.", (counter.reserved() >= 0L ? 1 : 0) != 0);
        GridCommandHandlerClusterByClassTest.assertTrue((String)"HWM/LWM invariant should be broken.", (counter.get() > counter.reserved() ? 1 : 0) != 0);
    }

    private void corruptingAndCheckDefaultCache(IgniteEx ignite, String cacheFilter, boolean dump) throws IOException {
        this.injectTestSystemOut();
        GridCacheContext cacheCtx = ignite.cachex("default").context();
        TestStorageUtils.corruptDataEntry((GridCacheContext)cacheCtx, (Object)0, (boolean)true, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        TestStorageUtils.corruptDataEntry((GridCacheContext)cacheCtx, (Object)(cacheCtx.config().getAffinity().partitions() / 2), (boolean)false, (boolean)true, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        String resReport = null;
        if (dump) {
            GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--cache-filter", cacheFilter));
            Matcher fileNameMatcher = this.dumpFileNameMatcher();
            if (fileNameMatcher.find()) {
                resReport = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
                log.info(resReport);
            } else {
                GridCommandHandlerClusterByClassTest.fail((String)"Should be found dump with conflicts");
            }
        } else {
            GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--cache-filter", cacheFilter));
            resReport = testOut.toString();
        }
        GridTestUtils.assertContains((IgniteLogger)log, (String)resReport, (String)"found 2 conflict partitions: [updateCounterConflicts=1, reserveCounterConflicts=0, hashConflicts=1]");
    }

    @Test
    public void testCacheIdleVerifyDumpForCorruptedDataOnSystemCache() throws Exception {
        int parts = 32;
        this.atomicConfiguration = new AtomicConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setBackups(2);
        IgniteEx ignite = crd;
        this.injectTestSystemOut();
        for (int i = 0; i < 100; ++i) {
            ignite.semaphore("s" + i, i, false, true);
            ignite.atomicSequence("sq" + i, 0L, true).incrementAndGet();
        }
        CacheGroupContext storedSysCacheCtx = ignite.context().cache().cacheGroup(CU.cacheId((String)"default-ds-group"));
        GridCommandHandlerClusterByClassTest.assertNotNull((Object)storedSysCacheCtx);
        TestStorageUtils.corruptDataEntry((GridCacheContext)((GridCacheContext)storedSysCacheCtx.caches().get(0)), (Object)new GridCacheInternalKeyImpl("sq0", "default-ds-group"), (boolean)true, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        TestStorageUtils.corruptDataEntry((GridCacheContext)((GridCacheContext)storedSysCacheCtx.caches().get(0)), (Object)new GridCacheInternalKeyImpl("sq" + parts / 2, "default-ds-group"), (boolean)false, (boolean)true, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        CacheGroupContext memoryVolatileCacheCtx = ignite.context().cache().cacheGroup(CU.cacheId((String)"default-volatile-ds-group@volatileDsMemPlc"));
        GridCommandHandlerClusterByClassTest.assertNotNull((Object)memoryVolatileCacheCtx);
        GridCommandHandlerClusterByClassTest.assertEquals((String)"volatileDsMemPlc", (String)memoryVolatileCacheCtx.dataRegion().config().getName());
        GridCommandHandlerClusterByClassTest.assertEquals((boolean)false, (boolean)memoryVolatileCacheCtx.dataRegion().config().isPersistenceEnabled());
        TestStorageUtils.corruptDataEntry((GridCacheContext)((GridCacheContext)memoryVolatileCacheCtx.caches().get(0)), (Object)new GridCacheInternalKeyImpl("s0", "default-volatile-ds-group@volatileDsMemPlc"), (boolean)true, (boolean)false, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        TestStorageUtils.corruptDataEntry((GridCacheContext)((GridCacheContext)memoryVolatileCacheCtx.caches().get(0)), (Object)new GridCacheInternalKeyImpl("s" + parts / 2, "default-volatile-ds-group@volatileDsMemPlc"), (boolean)false, (boolean)true, (GridCacheVersion)new GridCacheVersion(0, 0, 0L), (String)"broken");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--cache-filter", "SYSTEM"));
        Matcher fileNameMatcher = this.dumpFileNameMatcher();
        if (fileNameMatcher.find()) {
            String dumpWithConflicts = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
            U.log((IgniteLogger)log, (Object)dumpWithConflicts);
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithConflicts, (String)"found 4 conflict partitions: [updateCounterConflicts=2, reserveCounterConflicts=0, hashConflicts=2]");
        } else {
            GridCommandHandlerClusterByClassTest.fail((String)"Should be found dump with conflicts");
        }
    }

    @Test
    public void testCacheIdleVerifyDumpForCorruptedDataOnPersistenceClientCache() throws Exception {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.corruptingAndCheckDefaultCache(ignite, "PERSISTENT", true);
    }

    @Test
    public void testCacheIdleVerifyDumpExcludedCacheGrp() throws Exception {
        IgniteEx ignite = crd;
        int parts = 32;
        IgniteCache cache = ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setGroupName("shared_grp").setBackups(1).setName("default"));
        IgniteCache secondCache = ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setGroupName("shared_grp").setBackups(1).setName("default_second"));
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--exclude-caches", "shared_grp"));
        Matcher fileNameMatcher = this.dumpFileNameMatcher();
        if (fileNameMatcher.find()) {
            String dumpWithConflicts = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithConflicts, (String)"There are no caches matching given filter options");
        } else {
            GridCommandHandlerClusterByClassTest.fail((String)"Should be found dump with conflicts");
        }
    }

    @Test
    public void testCacheIdleVerifyDumpExcludedCaches() throws Exception {
        IgniteEx ignite = crd;
        int parts = 32;
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setGroupName("shared_grp").setBackups(1).setName("default"));
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setGroupName("shared_grp").setBackups(1).setName("default_second"));
        ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, parts)).setBackups(1).setName("default_third"));
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "idle_verify", "--dump", "--exclude-caches", "default,default_second"));
        Matcher fileNameMatcher = this.dumpFileNameMatcher();
        if (fileNameMatcher.find()) {
            String dumpWithConflicts = new String(Files.readAllBytes(Paths.get(fileNameMatcher.group(1), new String[0])));
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithConflicts, (String)"idle_verify check has finished, found 32 partitions");
            GridTestUtils.assertContains((IgniteLogger)log, (String)dumpWithConflicts, (String)"default_third");
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)dumpWithConflicts, (String)"shared_grp");
        } else {
            GridCommandHandlerClusterByClassTest.fail((String)"Should be found dump with conflicts");
        }
    }

    @NotNull
    private Matcher dumpFileNameMatcher() {
        Pattern fileNamePattern = Pattern.compile(".*VisorIdleVerifyDumpTask successfully written output to '(.*)'");
        return fileNamePattern.matcher(testOut.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCacheContention() throws Exception {
        int cnt = 10;
        ExecutorService svc = Executors.newFixedThreadPool(cnt);
        try {
            IgniteEx ignite = crd;
            IgniteCache cache = ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(1).setName("default"));
            final CountDownLatch l = new CountDownLatch(1);
            CountDownLatch l2 = new CountDownLatch(1);
            svc.submit(new Runnable((Ignite)ignite, cache, l, l2){
                final /* synthetic */ Ignite val$ignite;
                final /* synthetic */ IgniteCache val$cache;
                final /* synthetic */ CountDownLatch val$l;
                final /* synthetic */ CountDownLatch val$l2;
                {
                    this.val$ignite = ignite;
                    this.val$cache = igniteCache;
                    this.val$l = countDownLatch;
                    this.val$l2 = countDownLatch2;
                }

                @Override
                public void run() {
                    try (Transaction tx = this.val$ignite.transactions().txStart();){
                        this.val$cache.put((Object)0, (Object)0);
                        this.val$l.countDown();
                        U.awaitQuiet((CountDownLatch)this.val$l2);
                        tx.commit();
                    }
                }
            });
            for (int i = 0; i < cnt - 1; ++i) {
                svc.submit(new Runnable((Ignite)ignite, cache){
                    final /* synthetic */ Ignite val$ignite;
                    final /* synthetic */ IgniteCache val$cache;
                    {
                        this.val$ignite = ignite;
                        this.val$cache = igniteCache;
                    }

                    @Override
                    public void run() {
                        U.awaitQuiet((CountDownLatch)l);
                        try (Transaction tx = this.val$ignite.transactions().txStart();){
                            this.val$cache.get((Object)0);
                            tx.commit();
                        }
                    }
                });
            }
            U.awaitQuiet((CountDownLatch)l);
            Thread.sleep(300L);
            this.injectTestSystemOut();
            GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "contention", "5"));
            l2.countDown();
            String out = testOut.toString();
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"TxEntry");
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"op=READ");
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"op=CREATE");
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("id=" + this.ignite(0).cluster().localNode().id()));
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("id=" + this.ignite(1).cluster().localNode().id()));
        }
        finally {
            svc.shutdown();
            svc.awaitTermination(100L, TimeUnit.DAYS);
        }
    }

    @Test
    public void testCacheGroups() {
        IgniteEx ignite = crd;
        IgniteCache cache = ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setBackups(1).setGroupName("G100").setName("default"));
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "list", ".*", "--groups"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"G100");
    }

    @Test
    public void testCacheDestroy() throws IgniteCheckedException {
        String warningMsgPrefix = "Warning! The command will destroy";
        String requiredArgsMsg = "One of \"--caches\" or \"--destroy-all-caches\" is expected.";
        CacheConfiguration internalCfg = new CacheConfiguration("temp-internal-cache");
        crd.context().cache().dynamicStartCache(internalCfg, internalCfg.getName(), null, CacheType.INTERNAL, false, true, true, false).get(this.getTestTimeout());
        crd.countDownLatch("structure", 1, true, true);
        long internalCachesCnt = crd.context().cache().cacheDescriptors().values().stream().filter(desc -> desc.cacheType() == CacheType.INTERNAL || desc.cacheType() == CacheType.DATA_STRUCTURES).count();
        GridCommandHandlerClusterByClassTest.assertTrue((String)("Caches count: " + internalCachesCnt), (internalCachesCnt >= 2L ? 1 : 0) != 0);
        this.autoConfirmation = false;
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.DESTROY.text()));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)requiredArgsMsg);
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)warningMsgPrefix);
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "cacheX"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)("Invalid argument \"cacheX\". " + requiredArgsMsg));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)warningMsgPrefix);
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "--caches", "X", "--destroy-all-caches"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Invalid argument \"--destroy-all-caches");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)warningMsgPrefix);
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "--destroy-all-caches", "X"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Invalid argument \"X\"");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)warningMsgPrefix);
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "--caches", "X,Y", "Z"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Invalid argument \"Z\"");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)warningMsgPrefix);
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "--destroy-all-caches"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"No user-created caches exist.");
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)warningMsgPrefix);
        TreeSet<String> cacheNames = new TreeSet<String>();
        cacheNames.addAll(this.createCaches(0, 10, null));
        cacheNames.addAll(this.createCaches(10, 5, "shared1"));
        cacheNames.addAll(this.createCaches(15, 5, "shared2"));
        String expConfirmation = String.format("Warning! The command will destroy %d caches: %s.\nIf you continue, the cache data will be impossible to recover.", cacheNames.size(), S.joinToString(cacheNames, (String)", ", (String)"..", (int)80, (int)0));
        this.injectTestSystemIn("y");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "--caches", "shared1,shared2"));
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)crd.cacheNames().containsAll(cacheNames));
        this.injectTestSystemIn("y");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "--destroy-all-caches"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)expConfirmation);
        GridCommandHandlerClusterByClassTest.assertTrue((String)("Caches must be destroyed: " + crd.cacheNames().toString()), (boolean)crd.cacheNames().isEmpty());
        this.autoConfirmation = true;
        String qry = "CREATE TABLE Person (id LONG PRIMARY KEY, name VARCHAR) WITH \"CACHE_NAME=sql-cache\";";
        crd.context().query().querySqlFields(new SqlFieldsQuery(qry).setSchema("PUBLIC"), false, false);
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", CacheSubcommands.DESTROY.text(), "--destroy-all-caches"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)String.format("The following caches have been stopped: %s.", "sql-cache"));
        GridCommandHandlerClusterByClassTest.assertTrue((String)("Caches must be destroyed: " + crd.cacheNames().toString()), (boolean)crd.cacheNames().isEmpty());
    }

    @Test
    public void testCacheClear() throws IgniteCheckedException {
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.CLEAR.text()));
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.CLEAR.text(), "cacheX"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Unknown argument: cacheX");
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", CacheSubcommands.CLEAR.text(), "--caches", "X,Y", "Z"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)"Invalid argument \"Z\", no more arguments are expected.");
        this.autoConfirmation = false;
        String expConfirmation = String.format("Warning! The command will clear all data from %d caches: %s.\nIf you continue, it will be impossible to recover cleared data.", 2, "default, default0");
        this.injectTestSystemIn("y");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", CacheSubcommands.CLEAR.text(), "--caches", "default,default0"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)expConfirmation);
        this.autoConfirmation = true;
        List caches = F.asList((Object[])new String[]{"default", "default0"});
        for (boolean sql : new boolean[]{false, true}) {
            for (String cache : caches) {
                this.checkCacheClearCommand(caches, F.asList((Object)cache), sql);
            }
            this.checkCacheClearCommand(caches, F.asList((Object)"default"), sql);
            this.checkCacheClearCommand(caches, F.asList((Object[])new String[]{"default", "default0"}), sql);
            this.checkCacheClearCommand(caches, F.asList((Object)"cacheX"), sql);
            this.checkCacheClearCommand(caches, F.asList((Object[])new String[]{"cacheX", "default"}), sql);
        }
    }

    private void checkCacheClearCommand(List<String> caches, List<String> clearCaches, boolean sql) {
        int cnt = 100;
        for (String cache : caches) {
            if (sql) {
                this.sql("CREATE TABLE tbl_" + cache + "(id INT PRIMARY KEY, val INT) WITH \"CACHE_NAME=" + cache + "\";", new Object[0]);
                for (int i = 0; i < cnt; ++i) {
                    this.sql("insert into tbl_" + cache + "(id, val) values (?, ?)", i, i);
                }
                continue;
            }
            IgniteCache c2 = crd.createCache(new CacheConfiguration(cache));
            for (int i = 0; i < cnt; ++i) {
                c2.put((Object)i, (Object)i);
            }
        }
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", CacheSubcommands.CLEAR.text(), "--caches", String.join((CharSequence)",", clearCaches)));
        List nonExistentCaches = clearCaches.stream().filter(c -> !caches.contains(c)).collect(Collectors.toList());
        List clearedCaches = clearCaches.stream().filter(caches::contains).collect(Collectors.toList());
        if (!nonExistentCaches.isEmpty()) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)String.format("The following caches don't exist: %s", String.join((CharSequence)", ", nonExistentCaches)));
        } else {
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)String.format("The following caches don't exist: %s", ""));
        }
        if (!clearedCaches.isEmpty()) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)String.format("The following caches have been cleared: %s", String.join((CharSequence)", ", clearedCaches)));
        } else {
            GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)String.format("The following caches have been cleared: %s", ""));
        }
        for (String cache : caches) {
            int count = sql ? this.sql("select * from tbl_" + cache, new Object[0]).size() : crd.cache(cache).size(new CachePeekMode[0]);
            GridCommandHandlerClusterByClassTest.assertEquals((String)cache, (int)(clearCaches.contains(cache) ? 0 : cnt), (int)count);
        }
        if (sql) {
            for (String cache : caches) {
                this.sql("drop table tbl_" + cache, new Object[0]);
            }
        } else {
            crd.destroyCaches(caches);
        }
    }

    private List<?> sql(String sql, Object ... args) {
        return ((FieldsQueryCursor)crd.context().query().querySqlFields(new SqlFieldsQuery(sql).setArgs(args), false, false).get(0)).getAll();
    }

    private Collection<String> createCaches(int off, int cnt, String grpName) {
        ArrayList<CacheConfiguration> cfgs = new ArrayList<CacheConfiguration>(cnt);
        for (int i = off; i < off + cnt; ++i) {
            cfgs.add(new CacheConfiguration().setGroupName(grpName).setName("tmp-cache-" + String.format("%02d", i)));
        }
        crd.createCaches(cfgs);
        return F.viewReadOnly(cfgs, CacheConfiguration::getName, (IgnitePredicate[])new IgnitePredicate[0]);
    }

    @Test
    public void testCacheAffinity() {
        IgniteEx ignite = crd;
        IgniteCache cache1 = ignite.createCache(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setBackups(1).setName("default"));
        for (int i = 0; i < 100; ++i) {
            cache1.put((Object)i, (Object)i);
        }
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "list", ".*"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"cacheName=default");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"prim=32");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"mapped=32");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"affCls=RendezvousAffinityFunction");
    }

    @Test
    public void testCacheConfigNoOutputFormat() {
        this.testCacheConfig(null, 1, 1);
    }

    @Test
    public void testCacheConfigSingleLineOutputFormatSingleNodeSignleCache() {
        this.testCacheConfigSingleLineOutputFormat(1, 1);
    }

    @Test
    public void testCacheConfigSingleLineOutputFormatTwoNodeSignleCache() {
        this.testCacheConfigSingleLineOutputFormat(2, 1);
    }

    @Test
    public void testCacheConfigSingleLineOutputFormatTwoNodeManyCaches() {
        this.testCacheConfigSingleLineOutputFormat(2, 100);
    }

    @Test
    public void testCacheConfigMultiLineOutputFormatSingleNodeSingleCache() {
        this.testCacheConfigMultiLineOutputFormat(1, 1);
    }

    @Test
    public void testCacheConfigMultiLineOutputFormatTwoNodeSingleCache() {
        this.testCacheConfigMultiLineOutputFormat(2, 1);
    }

    @Test
    public void testCacheConfigMultiLineOutputFormatTwoNodeManyCaches() {
        this.testCacheConfigMultiLineOutputFormat(2, 100);
    }

    private void testCacheConfigSingleLineOutputFormat(int nodesCnt, int cachesCnt) {
        this.testCacheConfig("single-line", nodesCnt, cachesCnt);
    }

    private void testCacheConfigMultiLineOutputFormat(int nodesCnt, int cachesCnt) {
        this.testCacheConfig("multi-line", nodesCnt, cachesCnt);
    }

    private void testCacheConfig(String outputFormat, int nodesCnt, int cachesCnt) {
        GridCommandHandlerClusterByClassTest.assertTrue((String)"Invalid number of nodes or caches", (nodesCnt > 0 && cachesCnt > 0 ? 1 : 0) != 0);
        IgniteEx ignite = crd;
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>(cachesCnt);
        for (int i = 0; i < cachesCnt; ++i) {
            ccfgs.add(new CacheConfiguration().setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setBackups(1).setName("default" + i));
        }
        ignite.createCaches(ccfgs);
        IgniteCache cache1 = ignite.cache("default0");
        for (int i = 0; i < 100; ++i) {
            cache1.put((Object)i, (Object)i);
        }
        this.injectTestSystemOut();
        int exitCode = outputFormat == null ? this.execute("--cache", "list", ".*", "--config") : this.execute("--cache", "list", ".*", "--config", "--output-format", outputFormat);
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)exitCode);
        String outStr = testOut.toString();
        if (outputFormat == null || OutputFormat.SINGLE_LINE.text().equals(outputFormat)) {
            for (int i = 0; i < cachesCnt; ++i) {
                GridTestUtils.assertContains((IgniteLogger)log, (String)outStr, (String)("name=default" + i));
            }
            GridTestUtils.assertContains((IgniteLogger)log, (String)outStr, (String)"partitions=32");
            GridTestUtils.assertContains((IgniteLogger)log, (String)outStr, (String)"function=o.a.i.cache.affinity.rendezvous.RendezvousAffinityFunction");
        } else if (OutputFormat.MULTI_LINE.text().equals(outputFormat)) {
            for (int i = 0; i < cachesCnt; ++i) {
                GridTestUtils.assertContains((IgniteLogger)log, (String)outStr, (String)("[cache = 'default" + i + "']"));
            }
            GridTestUtils.assertContains((IgniteLogger)log, (String)outStr, (String)"Affinity Partitions: 32");
            GridTestUtils.assertContains((IgniteLogger)log, (String)outStr, (String)"Affinity Function: o.a.i.cache.affinity.rendezvous.RendezvousAffinityFunction");
        } else {
            GridCommandHandlerClusterByClassTest.fail((String)("Unknown output format: " + outputFormat));
        }
    }

    @Test
    public void testCacheDistribution() {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "distribution", "null"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"[next group: id=1544803905, name=default]");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"[next group: id=-2100569601, name=ignite-sys-cache]");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "distribution", "null", "--user-attributes", "ZONE,CELL,DC"));
        out = out + "\n" + testOut.toString();
        List outLines = Arrays.stream(out.split("\n")).map(String::trim).collect(Collectors.toList());
        int firstIndex = outLines.indexOf("[next group: id=1544803905, name=default]");
        int lastIndex = outLines.lastIndexOf("[next group: id=1544803905, name=default]");
        String dataLine = (String)outLines.get(firstIndex + 1);
        String userArrtDataLine = (String)outLines.get(lastIndex + 1);
        long commaNum = dataLine.chars().filter(i -> i == 44).count();
        long userArrtCommaNum = userArrtDataLine.chars().filter(i -> i == 44).count();
        GridCommandHandlerClusterByClassTest.assertEquals((long)3L, (long)(userArrtCommaNum - commaNum));
    }

    @Test
    public void testCacheResetLostPartitionsNoArgs() {
        this.autoConfirmation = false;
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)1, (int)this.execute("--cache", "reset_lost_partitions"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Check arguments. Expected either [--all] or [cacheName1,...,cacheNameN]");
    }

    @Test
    public void testCacheResetLostPartitions() {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "reset_lost_partitions", "ignite-sys-cache,default"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Reset LOST-partitions performed successfully. Cache group (name = 'ignite-sys-cache'");
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"Reset LOST-partitions performed successfully. Cache group (name = 'default'");
    }

    @Test
    public void testCacheResetLostPartitionsAll() {
        IgniteEx ignite = crd;
        this.createCacheAndPreload((Ignite)ignite, 100);
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--cache", "reset_lost_partitions", "--all"));
        String out = testOut.toString();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)"No caches with LOST partition has been found found.");
    }

    private void validate(CommandHandler h, IgniteInClosure<Map<ClusterNode, VisorTxTaskResult>> validateClo, String ... args) {
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute(h, args));
        validateClo.apply(h.getLastOperationResult());
    }

    private Map<Object, Object> generate(int from, int cnt) {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        for (int i = 0; i < cnt; ++i) {
            map.put(i + from, i + from);
        }
        return map;
    }

    @Test
    public void testUnusedWalPrint() {
        IgniteEx ignite = crd;
        ArrayList<String> nodes = new ArrayList<String>(2);
        for (ClusterNode node : ignite.cluster().forServers().nodes()) {
            nodes.add(node.consistentId().toString());
        }
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--wal", "print"));
        String out = testOut.toString();
        for (String id : nodes) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)id);
        }
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"error");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--wal", "print", (String)nodes.get(0)));
        out = testOut.toString();
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)((String)nodes.get(1)));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"error");
    }

    @Test
    public void testUnusedWalDelete() {
        IgniteEx ignite = crd;
        ArrayList<String> nodes = new ArrayList<String>(2);
        for (ClusterNode node : ignite.cluster().forServers().nodes()) {
            nodes.add(node.consistentId().toString());
        }
        this.injectTestSystemOut();
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--wal", "delete"));
        String out = testOut.toString();
        for (String id : nodes) {
            GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)id);
        }
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"error");
        GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute("--wal", "delete", (String)nodes.get(0)));
        out = testOut.toString();
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)((String)nodes.get(1)));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)out, (String)"error");
    }

    private IgniteInternalFuture<?> startTransactions(String testName, final CountDownLatch lockLatch, final CountDownLatch unlockLatch, final boolean topChangeBeforeUnlock) throws Exception {
        final IgniteEx client = this.grid("client");
        final AtomicInteger idx = new AtomicInteger();
        return this.multithreadedAsync(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                id = idx.getAndIncrement();
                switch (id) {
                    case 0: {
                        try {
                            tx = GridCommandHandlerClusterByClassTest.access$000(GridCommandHandlerClusterByClassTest.this, 0).transactions().txStart();
                            var3_7 = null;
                            GridCommandHandlerClusterByClassTest.access$200(GridCommandHandlerClusterByClassTest.this, 0).cache("default").putAll(GridCommandHandlerClusterByClassTest.access$100(GridCommandHandlerClusterByClassTest.this, 0, 100));
                            lockLatch.countDown();
                            U.awaitQuiet((CountDownLatch)unlockLatch);
                            tx.commit();
                            if (topChangeBeforeUnlock) {
                                GridCommandHandlerClusterByClassTest.access$300("Commit must fail");
                            }
                            if (tx == null) break;
                            if (var3_7 == null) ** GOTO lbl22
                            try {
                                tx.close();
                            }
                            catch (Throwable var4_11) {
                                var3_7.addSuppressed(var4_11);
                            }
                            break;
lbl22:
                            // 1 sources

                            tx.close();
                            ** break;
                            catch (Throwable var4_12) {
                                try {
                                    var3_7 = var4_12;
                                    throw var4_12;
                                }
                                catch (Throwable var5_19) {
                                    if (tx != null) {
                                        if (var3_7 != null) {
                                            try {
                                                tx.close();
                                            }
                                            catch (Throwable var6_20) {
                                                var3_7.addSuppressed(var6_20);
                                            }
                                        } else {
                                            tx.close();
                                        }
                                    }
                                    throw var5_19;
lbl39:
                                    // 1 sources

                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            if (topChangeBeforeUnlock) {
                                GridCommandHandlerClusterByClassTest.access$400(X.hasCause((Throwable)e, (Class[])new Class[]{TransactionRollbackException.class}));
                                break;
                            }
                            throw e;
                        }
                    }
                    case 1: {
                        U.awaitQuiet((CountDownLatch)lockLatch);
                        GridAbstractTest.doSleep((long)3000L);
                        tx = GridCommandHandlerClusterByClassTest.access$500(GridCommandHandlerClusterByClassTest.this, 0).transactions().withLabel("label1").txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.READ_COMMITTED, 0x7FFFFFFFL, 0);
                        var3_8 = null;
                        GridCommandHandlerClusterByClassTest.access$600(GridCommandHandlerClusterByClassTest.this, 0).cache("default").putAll(GridCommandHandlerClusterByClassTest.access$100(GridCommandHandlerClusterByClassTest.this, 200, 110));
                        GridCommandHandlerClusterByClassTest.access$700(GridCommandHandlerClusterByClassTest.this, 0).cache("default").put((Object)0, (Object)0);
                        if (tx == null) break;
                        if (var3_8 == null) ** GOTO lbl61
                        try {
                            tx.close();
                        }
                        catch (Throwable var4_13) {
                            var3_8.addSuppressed(var4_13);
                        }
                        break;
lbl61:
                        // 1 sources

                        tx.close();
                        break;
                        catch (Throwable var4_14) {
                            try {
                                var3_8 = var4_14;
                                throw var4_14;
                            }
                            catch (Throwable var7_21) {
                                if (tx != null) {
                                    if (var3_8 != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable var8_22) {
                                            var3_8.addSuppressed(var8_22);
                                        }
                                    } else {
                                        tx.close();
                                    }
                                }
                                throw var7_21;
                            }
                        }
                    }
                    case 2: {
                        tx = GridCommandHandlerClusterByClassTest.access$800(GridCommandHandlerClusterByClassTest.this, 1).transactions().txStart();
                        var3_9 = null;
                        U.awaitQuiet((CountDownLatch)lockLatch);
                        GridCommandHandlerClusterByClassTest.access$900(GridCommandHandlerClusterByClassTest.this, 1).cache("default").put((Object)0, (Object)0);
                        if (tx == null) break;
                        if (var3_9 == null) ** GOTO lbl92
                        try {
                            tx.close();
                        }
                        catch (Throwable var4_15) {
                            var3_9.addSuppressed(var4_15);
                        }
                        break;
lbl92:
                        // 1 sources

                        tx.close();
                        break;
                        catch (Throwable var4_16) {
                            try {
                                var3_9 = var4_16;
                                throw var4_16;
                            }
                            catch (Throwable var9_23) {
                                if (tx != null) {
                                    if (var3_9 != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable var10_24) {
                                            var3_9.addSuppressed(var10_24);
                                        }
                                    } else {
                                        tx.close();
                                    }
                                }
                                throw var9_23;
                            }
                        }
                    }
                    case 3: {
                        tx = client.transactions().withLabel("label2").txStart(TransactionConcurrency.OPTIMISTIC, TransactionIsolation.READ_COMMITTED, 0L, 0);
                        var3_10 = null;
                        U.awaitQuiet((CountDownLatch)lockLatch);
                        client.cache("default").putAll(GridCommandHandlerClusterByClassTest.access$100(GridCommandHandlerClusterByClassTest.this, 100, 10));
                        client.cache("default").put((Object)0, (Object)0);
                        tx.commit();
                        if (tx == null) break;
                        if (var3_10 == null) ** GOTO lbl125
                        try {
                            tx.close();
                        }
                        catch (Throwable var4_17) {
                            var3_10.addSuppressed(var4_17);
                        }
                        break;
lbl125:
                        // 1 sources

                        tx.close();
                        break;
                        catch (Throwable var4_18) {
                            try {
                                var3_10 = var4_18;
                                throw var4_18;
                            }
                            catch (Throwable var11_25) {
                                if (tx != null) {
                                    if (var3_10 != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable var12_26) {
                                            var3_10.addSuppressed(var12_26);
                                        }
                                    } else {
                                        tx.close();
                                    }
                                }
                                throw var11_25;
                            }
                        }
                    }
                }
            }
        }, 4, "tx-thread-" + testName);
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_ENABLE_EXPERIMENTAL_COMMAND", value="true"), @WithSystemProperty(key="DISTRIBUTED_ROLLING_UPGRADE_MODE", value="true")})
    public void testContainsNotExperimentalCmdInHelpOutputWhenEnableExperimentalTrue() {
        this.checkContainsNotExperimentalCmdInHelpOutput();
    }

    @Test
    @SystemPropertiesList(value={@WithSystemProperty(key="IGNITE_ENABLE_EXPERIMENTAL_COMMAND", value="false"), @WithSystemProperty(key="DISTRIBUTED_ROLLING_UPGRADE_MODE", value="true")})
    public void testContainsNotExperimentalCmdInHelpOutputWhenEnableExperimentalFalse() {
        this.checkContainsNotExperimentalCmdInHelpOutput();
    }

    @Test
    @WithSystemProperty(key="IGNITE_ENABLE_EXPERIMENTAL_COMMAND", value="true")
    public void testContainsExperimentalCmdInHelpOutput() {
        this.checkExperimentalCmdInHelpOutput(true);
    }

    @Test
    @WithSystemProperty(key="IGNITE_ENABLE_EXPERIMENTAL_COMMAND", value="false")
    public void testNotContainsExperimentalCmdInHelpOutput() {
        this.checkExperimentalCmdInHelpOutput(false);
    }

    @Test
    @WithSystemProperty(key="IGNITE_ENABLE_EXPERIMENTAL_COMMAND", value="false")
    public void testContainsWarnInsteadExecExperimentalCmdWhenEnableExperimentalFalse() {
        this.injectTestSystemOut();
        EnumMap<CommandList, List<String>> cmdArgs = new EnumMap<CommandList, List<String>>(CommandList.class);
        cmdArgs.put(CommandList.WAL, Arrays.asList("print", "delete"));
        cmdArgs.put(CommandList.TRACING_CONFIGURATION, Collections.singletonList("get_all"));
        cmdArgs.put(CommandList.METADATA, Arrays.asList("help", "list"));
        String warning = String.format("For use experimental command add %s=true to JVM_OPTS in %s", "IGNITE_ENABLE_EXPERIMENTAL_COMMAND", "control.(sh|bat)");
        Arrays.stream(CommandList.values()).filter(cmd -> cmd.command().experimental()).peek(cmd -> GridCommandHandlerClusterByClassTest.assertTrue((String)("Not contains " + cmd), (boolean)cmdArgs.containsKey(cmd))).forEach(cmd -> ((Collection)cmdArgs.get(cmd)).forEach(cmdArg -> {
            GridCommandHandlerClusterByClassTest.assertEquals((int)0, (int)this.execute(cmd.text(), (String)cmdArg));
            GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)warning);
        }));
    }

    @Test
    public void testCorrectExecCmdWithVerboseInDiffParamsOrder() {
        this.injectTestSystemOut();
        int resCode = 0;
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(CommandList.BASELINE.text(), "--verbose"));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute("--verbose", CommandList.BASELINE.text()));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
    }

    @Test
    public void testErrInvalidArgumentsWithVerbose() {
        this.injectTestSystemOut();
        int resCode = 1;
        String uuid = UUID.randomUUID().toString();
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(CommandList.BASELINE.text(), uuid));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(CommandList.BASELINE.text(), "--verbose", uuid));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
    }

    @Test
    public void testErrConnectionWithVerbose() {
        this.injectTestSystemOut();
        int resCode = 2;
        String uuid = UUID.randomUUID().toString();
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(CommandList.BASELINE.text(), "--host", uuid));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(CommandList.BASELINE.text(), "--verbose", "--host", uuid));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
    }

    @Test
    public void testErrIllegalStateWithVerbose() {
        this.injectTestSystemOut();
        int resCode = 5;
        String uuid = UUID.randomUUID().toString();
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(CommandList.BASELINE.text(), BaselineSubcommands.ADD.text(), uuid));
        GridTestUtils.assertNotContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(CommandList.BASELINE.text(), BaselineSubcommands.ADD.text(), uuid, "--verbose"));
        GridTestUtils.assertContains((IgniteLogger)log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
    }

    @Test
    public void testErrUnexpectedWithWithoutVerbose() {
        this.injectTestSystemOut();
        Logger log = CommandHandler.initLogger(null);
        log.addHandler(new StreamHandler(System.out, new Formatter(){

            @Override
            public String format(LogRecord record) {
                String msg = record.getMessage();
                if (msg.contains("Cluster state:")) {
                    throw new Error();
                }
                return msg + "\n";
            }
        }));
        int resCode = 4;
        CommandHandler cmd = new CommandHandler(log);
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(cmd, CommandList.BASELINE.text()));
        GridTestUtils.assertContains((IgniteLogger)GridAbstractTest.log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
        GridCommandHandlerClusterByClassTest.assertEquals((int)resCode, (int)this.execute(cmd, CommandList.BASELINE.text(), "--verbose"));
        GridTestUtils.assertContains((IgniteLogger)GridAbstractTest.log, (String)testOut.toString(), (String)ERROR_STACK_TRACE_PREFIX);
    }

    private void checkExperimentalCmdInHelpOutput(boolean contains) {
        this.execHelpCmd(helpOut -> Arrays.stream(CommandList.values()).filter(cmd -> cmd.command().experimental()).forEach(cmd -> {
            if (contains) {
                GridTestUtils.assertContains((IgniteLogger)log, (String)helpOut, (String)cmd.text());
            } else {
                GridTestUtils.assertNotContains((IgniteLogger)log, (String)helpOut, (String)cmd.text());
            }
        }));
    }

    private void checkContainsNotExperimentalCmdInHelpOutput() {
        this.execHelpCmd(helpOut -> Arrays.stream(CommandList.values()).filter(cmd -> !cmd.command().experimental()).forEach(cmd -> GridTestUtils.assertContains((IgniteLogger)log, (String)helpOut, (String)cmd.text())));
    }

    private void execHelpCmd(Consumer<String> consumer) {
        assert (Objects.nonNull(consumer));
        this.injectTestSystemOut();
        this.execute("--help");
        consumer.accept(testOut.toString());
    }

    static /* synthetic */ IgniteEx access$000(GridCommandHandlerClusterByClassTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ Map access$100(GridCommandHandlerClusterByClassTest x0, int x1, int x2) {
        return x0.generate(x1, x2);
    }

    static /* synthetic */ IgniteEx access$200(GridCommandHandlerClusterByClassTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ void access$300(String x0) {
        GridCommandHandlerClusterByClassTest.fail((String)x0);
    }

    static /* synthetic */ void access$400(boolean x0) {
        GridCommandHandlerClusterByClassTest.assertTrue((boolean)x0);
    }

    static /* synthetic */ IgniteEx access$500(GridCommandHandlerClusterByClassTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$600(GridCommandHandlerClusterByClassTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$700(GridCommandHandlerClusterByClassTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$800(GridCommandHandlerClusterByClassTest x0, int x1) {
        return x0.grid(x1);
    }

    static /* synthetic */ IgniteEx access$900(GridCommandHandlerClusterByClassTest x0, int x1) {
        return x0.grid(x1);
    }
}

