/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.util.GridCommandHandlerClusterByClassAbstractTest;
import org.junit.Before;
import org.junit.Test;

public class GridCommandHandlerCheckpointingTest
extends GridCommandHandlerClusterByClassAbstractTest {
    @Before
    public void init() {
        this.injectTestSystemOut();
    }

    @Test
    public void testForceCheckpointing() {
        GridCacheDatabaseSharedManager gridDb = (GridCacheDatabaseSharedManager)crd.context().cache().context().database();
        CheckpointHistory checkpointHist = gridDb.checkpointHistory();
        assert (null != checkpointHist);
        int numOfCheckpointsBefore = checkpointHist.checkpoints().size();
        CheckpointEntry lastCheckpointBefore = checkpointHist.lastCheckpoint();
        this.createCacheAndPreload((Ignite)crd, 1);
        GridCommandHandlerCheckpointingTest.assertEquals((int)0, (int)this.execute("--checkpoint"));
        int numOfCheckpointsAfter = checkpointHist.checkpoints().size();
        CheckpointEntry lastCheckpointAfter = checkpointHist.lastCheckpoint();
        GridCommandHandlerCheckpointingTest.assertTrue((numOfCheckpointsAfter > numOfCheckpointsBefore ? 1 : 0) != 0);
        GridCommandHandlerCheckpointingTest.assertNotSame((Object)lastCheckpointBefore, (Object)lastCheckpointAfter);
        String out = testOut.toString();
        int numOfNodes = crd.cluster().forServers().nodes().size();
        GridTestUtils.assertContains((IgniteLogger)log, (String)out, (String)("Checkpointing completed successfully on " + numOfNodes + " nodes."));
    }
}

