/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.configuration.Factory;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.NoopConsole;
import org.apache.ignite.internal.processors.security.impl.TestSecurityData;
import org.apache.ignite.internal.processors.security.impl.TestSecurityPluginProvider;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.plugin.security.SecurityPermissionSetBuilder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class GridCommandHandlerSslWithSecurityTest
extends GridCommonAbstractTest {
    private final String login = "testUsr";
    private final String pwd = "testPwd";

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setPluginProviders(new PluginProvider[]{new TestSecurityPluginProvider("testUsr", "testPwd", SecurityPermissionSetBuilder.ALLOW_ALL, false, new TestSecurityData[0])}).setSslContextFactory((Factory)GridTestUtils.sslTrustedFactory((String)"node01", (String)"trustone")).setConnectorConfiguration(new ConnectorConfiguration().setSslEnabled(true).setSslFactory((Factory)GridTestUtils.sslTrustedFactory((String)"connectorServer", (String)"trustthree")));
    }

    @Test
    public void testInputKeyTrustStorePwdOnlyOnce() throws Exception {
        IgniteEx crd = this.startGrid();
        crd.cluster().active(true);
        CommandHandler cmd = new CommandHandler();
        final AtomicInteger keyStorePwdCnt = new AtomicInteger();
        final AtomicInteger trustStorePwdCnt = new AtomicInteger();
        cmd.console = new NoopConsole(){

            public char[] readPassword(String fmt, Object ... args) {
                if (fmt.contains("keystore")) {
                    keyStorePwdCnt.incrementAndGet();
                    return GridTestUtils.keyStorePassword().toCharArray();
                }
                if (fmt.contains("truststore")) {
                    trustStorePwdCnt.incrementAndGet();
                    return GridTestUtils.keyStorePassword().toCharArray();
                }
                return "testPwd".toCharArray();
            }
        };
        ArrayList<String> args = new ArrayList<String>();
        args.add(CommandList.DEACTIVATE.text());
        args.add("--yes");
        args.add("--user");
        args.add("testUsr");
        args.add("--keystore");
        args.add(GridTestUtils.keyStorePath((String)"connectorServer"));
        args.add("--truststore");
        args.add(GridTestUtils.keyStorePath((String)"trustthree"));
        GridCommandHandlerSslWithSecurityTest.assertEquals((int)0, (int)cmd.execute(args));
        GridCommandHandlerSslWithSecurityTest.assertEquals((int)1, (int)keyStorePwdCnt.get());
        GridCommandHandlerSslWithSecurityTest.assertEquals((int)1, (int)trustStorePwdCnt.get());
    }

    @Test
    public void testConnector() throws Exception {
        IgniteEx crd = this.startGrid();
        crd.cluster().active(true);
        CommandHandler hnd = new CommandHandler();
        int exitCode = hnd.execute(Arrays.asList("--state", "--user", "testUsr", "--password", "testPwd", "--keystore", GridTestUtils.keyStorePath((String)"connectorClient"), "--keystore-password", GridTestUtils.keyStorePassword(), "--truststore", GridTestUtils.keyStorePath((String)"trustthree"), "--truststore-password", GridTestUtils.keyStorePassword()));
        GridCommandHandlerSslWithSecurityTest.assertEquals((int)0, (int)exitCode);
    }
}

