/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.BaselineChangedEvent;
import org.apache.ignite.events.BaselineConfigurationChangedEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.commandline.CommandHandler;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public abstract class IgniteControlUtilityBaselineEventsTest
extends GridCommonAbstractTest {
    private int[] includedEvtTypes = EventType.EVTS_ALL;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setConnectorConfiguration(new ConnectorConfiguration()).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)).setWalSegments(3).setWalSegmentSize(524288)).setConsistentId((Serializable)((Object)igniteInstanceName)).setIncludeEventTypes(this.includedEvtTypes);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected abstract void listen(IgniteEx var1, IgnitePredicate<Event> var2, int ... var3);

    @Test
    public void testChangeBltWithControlUtility() throws Exception {
        this.startGrid(0).cluster().active(true);
        AtomicBoolean baselineChanged = new AtomicBoolean();
        this.startGrid(1);
        String consistentIds = this.grid(0).localNode().consistentId() + "," + this.grid(1).localNode().consistentId();
        this.listen(this.grid(1), (IgnitePredicate<Event>)(IgnitePredicate & Serializable)event -> {
            baselineChanged.set(true);
            BaselineChangedEvent baselineChangedEvt = (BaselineChangedEvent)event;
            IgniteControlUtilityBaselineEventsTest.assertEquals((int)2, (int)baselineChangedEvt.baselineNodes().size());
            return true;
        }, 146);
        IgniteControlUtilityBaselineEventsTest.assertEquals((int)0, (int)new CommandHandler().execute(Arrays.asList("--baseline", "set", consistentIds, "--yes")));
        IgniteControlUtilityBaselineEventsTest.assertTrue((boolean)GridTestUtils.waitForCondition(baselineChanged::get, (long)3000L));
    }

    @Test
    public void testChangeAutoAdjustEnabled() throws Exception {
        IgniteClusterEx cluster = this.startGrids(2).cluster();
        cluster.active(true);
        IgniteControlUtilityBaselineEventsTest.assertFalse((boolean)cluster.isBaselineAutoAdjustEnabled());
        AtomicBoolean autoAdjustEnabled = new AtomicBoolean();
        this.listen(this.grid(0), (IgnitePredicate<Event>)(IgnitePredicate & Serializable)event -> {
            BaselineConfigurationChangedEvent bltCfgChangedEvt = (BaselineConfigurationChangedEvent)event;
            autoAdjustEnabled.set(bltCfgChangedEvt.isAutoAdjustEnabled());
            return true;
        }, 147);
        IgniteControlUtilityBaselineEventsTest.assertEquals((int)0, (int)new CommandHandler().execute(Arrays.asList("--baseline", "auto_adjust", "enable", "timeout", "10", "--yes")));
        IgniteControlUtilityBaselineEventsTest.assertTrue((boolean)GridTestUtils.waitForCondition(autoAdjustEnabled::get, (long)3000L));
        IgniteControlUtilityBaselineEventsTest.assertEquals((int)0, (int)new CommandHandler().execute(Arrays.asList("--baseline", "auto_adjust", "disable", "--yes")));
        IgniteControlUtilityBaselineEventsTest.assertFalse((boolean)autoAdjustEnabled.get());
        cluster.baselineAutoAdjustEnabled(true);
        IgniteControlUtilityBaselineEventsTest.assertTrue((boolean)GridTestUtils.waitForCondition(autoAdjustEnabled::get, (long)3000L));
        cluster.baselineAutoAdjustEnabled(false);
        IgniteControlUtilityBaselineEventsTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> !autoAdjustEnabled.get(), (long)3000L));
    }

    @Test
    public void testChangeAutoAdjustTimeout() throws Exception {
        IgniteClusterEx cluster = this.startGrids(2).cluster();
        cluster.active(true);
        AtomicLong autoAdjustTimeout = new AtomicLong();
        this.listen(this.grid(0), (IgnitePredicate<Event>)(IgnitePredicate & Serializable)event -> {
            BaselineConfigurationChangedEvent bltCfgChangedEvt = (BaselineConfigurationChangedEvent)event;
            autoAdjustTimeout.set(bltCfgChangedEvt.autoAdjustTimeout());
            return true;
        }, 148);
        IgniteControlUtilityBaselineEventsTest.assertEquals((int)0, (int)new CommandHandler().execute(Arrays.asList("--baseline", "auto_adjust", "enable", "timeout", "10", "--yes")));
        IgniteControlUtilityBaselineEventsTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> autoAdjustTimeout.get() == 10L, (long)3000L));
        cluster.baselineAutoAdjustTimeout(50L);
        IgniteControlUtilityBaselineEventsTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> autoAdjustTimeout.get() == 50L, (long)3000L));
    }

    @Test
    public void testEventsDisabledByDefault() throws Exception {
        this.includedEvtTypes = new int[0];
        IgniteClusterEx cluster = this.startGrid(0).cluster();
        cluster.active(true);
        AtomicInteger evtsTriggered = new AtomicInteger();
        this.listen(this.grid(0), (IgnitePredicate<Event>)(IgnitePredicate & Serializable)event -> {
            evtsTriggered.incrementAndGet();
            return true;
        }, 147, 148);
        this.startGrid(1);
        String consistentIds = this.grid(0).localNode().consistentId() + "," + this.grid(1).localNode().consistentId();
        IgniteControlUtilityBaselineEventsTest.assertEquals((int)0, (int)new CommandHandler().execute(Arrays.asList("--baseline", "set", consistentIds, "--yes")));
        this.awaitPartitionMapExchange();
        this.startGrid(2);
        cluster.setBaselineTopology(cluster.topologyVersion());
        this.awaitPartitionMapExchange();
        IgniteControlUtilityBaselineEventsTest.assertEquals((int)0, (int)new CommandHandler().execute(Arrays.asList("--baseline", "auto_adjust", "enable", "timeout", "10", "--yes")));
        cluster.baselineAutoAdjustEnabled(false);
        cluster.baselineAutoAdjustTimeout(50L);
        IgniteControlUtilityBaselineEventsTest.assertFalse((boolean)GridTestUtils.waitForCondition(() -> evtsTriggered.get() > 0, (long)3000L));
    }
}

