/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.AnyNodeConfigurationVisitor;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeysTrackingConfigurationVisitor;
import org.apache.ignite.internal.configuration.validation.CamelCaseKeysValidator;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidator;
import org.apache.ignite.internal.configuration.validation.EndpointValidator;
import org.apache.ignite.internal.configuration.validation.ExceptKeysValidator;
import org.apache.ignite.internal.configuration.validation.ImmutableValidator;
import org.apache.ignite.internal.configuration.validation.MemberKey;
import org.apache.ignite.internal.configuration.validation.NotBlankValidator;
import org.apache.ignite.internal.configuration.validation.OneOfValidator;
import org.apache.ignite.internal.configuration.validation.PowerOfTwoValidator;
import org.apache.ignite.internal.configuration.validation.RangeValidator;
import org.apache.ignite.internal.configuration.validation.StorageStringSizeValidator;
import org.apache.ignite.internal.configuration.validation.ValidationContextImpl;
import org.jetbrains.annotations.Nullable;

public class ConfigurationValidatorImpl
implements ConfigurationValidator {
    private static final Set<Validator<?, ?>> DEFAULT_VALIDATORS = Set.of(new ImmutableValidator(), new OneOfValidator(), new ExceptKeysValidator(), new PowerOfTwoValidator(), new RangeValidator(), new NotBlankValidator(), new CamelCaseKeysValidator(), new EndpointValidator(), new StorageStringSizeValidator());
    private final Map<MemberKey, Map<Annotation, Set<Validator<?, ?>>>> cachedAnnotations = new ConcurrentHashMap();
    private final ConfigurationTreeGenerator generator;
    private final Set<? extends Validator<?, ?>> validators;

    public ConfigurationValidatorImpl(ConfigurationTreeGenerator generator, Set<? extends Validator<?, ?>> validators) {
        assert (generator != null);
        assert (validators != null);
        this.generator = generator;
        this.validators = validators;
    }

    public static ConfigurationValidatorImpl withDefaultValidators(ConfigurationTreeGenerator generator, Set<? extends Validator<?, ?>> validators) {
        HashSet validators0 = new HashSet(DEFAULT_VALIDATORS);
        validators0.addAll(validators);
        return new ConfigurationValidatorImpl(generator, validators0);
    }

    @Override
    public List<ValidationIssue> validateHocon(String cfg) {
        try {
            Config config = ConfigFactory.parseString((String)cfg);
            return this.validate(HoconConverter.hoconSource(config.root()));
        }
        catch (ConfigException.Parse e) {
            throw new IllegalArgumentException("Failed to parse license", e);
        }
    }

    @Override
    public List<ValidationIssue> validate(ConfigurationSource src) {
        SuperRoot changes = this.emptySuperRoot();
        src.descend(changes);
        ConfigurationUtil.addDefaults(changes);
        ConfigurationUtil.dropNulls(changes);
        return this.validate(this.emptySuperRoot(), changes);
    }

    @Override
    public List<ValidationIssue> validate(SuperRoot newRoots) {
        return this.validate(this.emptySuperRoot(), newRoots);
    }

    @Override
    public List<ValidationIssue> validate(final SuperRoot oldRoots, final SuperRoot newRoots) {
        final ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>();
        newRoots.traverseChildren(new KeysTrackingConfigurationVisitor<Object>(){

            @Override
            protected Object doVisitInnerNode(Field field, String key, final InnerNode innerNode) {
                assert (innerNode != null);
                innerNode.traverseChildren(new AnyNodeConfigurationVisitor<Void>(){

                    @Override
                    protected Void visitNode(String key, Object node) {
                        this.validate(innerNode, key, node);
                        return null;
                    }
                }, true);
                return super.doVisitInnerNode(field, key, innerNode);
            }

            private void validate(InnerNode lastInnerNode, String fieldName, Object val) {
                if (val == null) {
                    String message = "'" + this.currentKey() + fieldName + "' configuration value is not initialized.";
                    issues.add(new ValidationIssue(this.currentKey(), message));
                    return;
                }
                MemberKey memberKey = new MemberKey(lastInnerNode.schemaType(), fieldName);
                Map fieldAnnotations = ConfigurationValidatorImpl.this.cachedAnnotations.computeIfAbsent(memberKey, k -> {
                    Field field = ConfigurationValidatorImpl.findSchemaField(lastInnerNode, fieldName);
                    assert (field != null) : "Field " + fieldName + " not found for " + lastInnerNode.schemaType().getSimpleName();
                    return Stream.of(field.getDeclaredAnnotations()).collect(Collectors.toMap(Function.identity(), annotation -> ConfigurationValidatorImpl.this.validators.stream().filter(validator -> validator.canValidate(annotation.annotationType(), field.getType(), field.isAnnotationPresent(NamedConfigValue.class))).collect(Collectors.toSet())));
                });
                if (fieldAnnotations.isEmpty()) {
                    return;
                }
                String currentKey = this.currentKey() + fieldName;
                List<String> currentPath = ConfigurationUtil.appendKey(this.currentPath(), fieldName);
                for (Map.Entry entry : fieldAnnotations.entrySet()) {
                    Annotation annotation = (Annotation)entry.getKey();
                    for (Validator validator : (Set)entry.getValue()) {
                        ValidationContextImpl<Object> ctx = new ValidationContextImpl<Object>(oldRoots, newRoots, val, currentKey, currentPath, issues);
                        validator.validate(annotation, ctx);
                    }
                }
            }
        }, true);
        return issues;
    }

    @Nullable
    private static Field findSchemaField(InnerNode innerNode, String publicName) {
        Class<?> schemaType = innerNode.schemaType();
        if (innerNode.isPolymorphic() || innerNode.extendsAbstractConfiguration()) {
            Field field = ConfigurationValidatorImpl.findSchemaField(schemaType, publicName);
            if (field != null) {
                return field;
            }
            schemaType = schemaType.getSuperclass();
        } else if (innerNode.extensionSchemaTypes() != null) {
            for (Class<?> extensionSchemaType : innerNode.extensionSchemaTypes()) {
                Field field = ConfigurationValidatorImpl.findSchemaField(extensionSchemaType, publicName);
                if (field == null) continue;
                return field;
            }
        }
        return ConfigurationValidatorImpl.findSchemaField(schemaType, publicName);
    }

    @Nullable
    private static Field findSchemaField(Class<?> schemaType, String publicName) {
        for (Field field : schemaType.getDeclaredFields()) {
            if (!ConfigurationAsmGenerator.publicName(field).equals(publicName)) continue;
            return field;
        }
        return null;
    }

    private SuperRoot emptySuperRoot() {
        return this.generator.createSuperRoot();
    }
}

