/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import org.apache.ignite.configuration.validation.MultipleOf;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;

public class MultipleOfValidator
implements Validator<MultipleOf, Number> {
    public void validate(MultipleOf annotation, ValidationContext<Number> ctx) {
        long annotationValue = annotation.value();
        if (annotationValue <= 0L) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Value must be positive."));
            return;
        }
        long value = ((Number)ctx.getNewValue()).longValue();
        if (value % annotationValue != 0L) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Configuration value '" + value + "' must be a multiple of " + annotationValue));
        }
    }
}

