/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationExtension;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InjectedValue;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.direct.KeyPathNode;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.tree.TraversableTreeNode;
import org.apache.ignite.internal.configuration.util.KeyNotFoundException;
import org.apache.ignite.internal.configuration.util.KeysTrackingConfigurationVisitor;
import org.apache.ignite.internal.configuration.util.NodeValue;
import org.apache.ignite.internal.configuration.util.WrongPolymorphicTypeIdException;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    public static final ConfigurationSource EMPTY_CFG_SRC = new ConfigurationSource(){};
    public static final String KEY_SEPARATOR = ".";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([.\\\\])");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("\\\\([.\\\\])");
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\)[.]");

    public static String escape(String key) {
        return ESCAPE_PATTERN.matcher(key).replaceAll("\\\\$1");
    }

    public static String unescape(String key) {
        return UNESCAPE_PATTERN.matcher(key).replaceAll("$1");
    }

    public static List<String> split(String keys) {
        String[] split = SPLIT_PATTERN.split(keys, -1);
        for (int i = 0; i < split.length; ++i) {
            split[i] = ConfigurationUtil.unescape(split[i]);
        }
        return Arrays.asList(split);
    }

    public static String join(List<String> keys) {
        return keys.stream().map(ConfigurationUtil::escape).collect(Collectors.joining(KEY_SEPARATOR));
    }

    public static <T> NodeValue<T> find(final List<String> keys, TraversableTreeNode node, final boolean includeInternal) throws KeyNotFoundException, WrongPolymorphicTypeIdException {
        assert (keys instanceof RandomAccess) : keys.getClass();
        ConfigurationVisitor visitor = new ConfigurationVisitor<NodeValue<T>>(){
            private int idx;

            @Override
            public NodeValue<T> visitLeafNode(Field field, String key, Serializable val) {
                if (this.idx != keys.size()) {
                    throw new KeyNotFoundException("Configuration value '" + ConfigurationUtil.join(keys.subList(0, this.idx)) + "' is a leaf");
                }
                return new NodeValue<Serializable>(field, val);
            }

            @Override
            public NodeValue<T> visitInnerNode(Field field, String key, InnerNode node) {
                if (this.idx == keys.size()) {
                    return new NodeValue<InnerNode>(field, node);
                }
                if (node == null) {
                    throw new KeyNotFoundException("Configuration node '" + ConfigurationUtil.join(keys.subList(0, this.idx)) + "' is null");
                }
                try {
                    return (NodeValue)node.traverseChild((String)keys.get(this.idx++), this, includeInternal);
                }
                catch (NoSuchElementException e) {
                    throw new KeyNotFoundException("Configuration value '" + ConfigurationUtil.join(keys.subList(0, this.idx)) + "' has not been found");
                }
                catch (ConfigurationWrongPolymorphicTypeIdException e) {
                    throw new WrongPolymorphicTypeIdException("Polymorphic configuration type is not correct: " + e.getMessage(), e);
                }
            }

            @Override
            public NodeValue<T> visitNamedListNode(Field field, String key, NamedListNode<?> node) {
                if (this.idx == keys.size()) {
                    return new NodeValue(field, node);
                }
                String name = (String)keys.get(this.idx++);
                return this.visitInnerNode(field, name, node.getInnerNode(name));
            }
        };
        return (NodeValue)node.accept(null, null, visitor);
    }

    public static Map<String, ?> toPrefixMap(Map<String, ? extends Serializable> rawConfig) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry<String, ? extends Serializable> entry : rawConfig.entrySet()) {
            List<String> keys = ConfigurationUtil.split(entry.getKey());
            assert (keys instanceof RandomAccess) : keys.getClass();
            ConfigurationUtil.insert(res, keys, 0, entry.getValue());
        }
        return res;
    }

    private static void insert(Map<String, Object> map, List<String> keys, int idx, Serializable val) {
        String key = keys.get(idx);
        if (keys.size() == idx + 1) {
            assert (!map.containsKey(key)) : map.get(key);
            map.put(key, val);
        } else {
            HashMap<String, Object> submap;
            Object node = map.get(key);
            if (node == null) {
                submap = new HashMap();
                map.put(key, submap);
            } else {
                assert (node instanceof Map) : node;
                submap = (Map)node;
            }
            ConfigurationUtil.insert(submap, keys, idx + 1, val);
        }
    }

    public static void fillFromPrefixMap(InnerNode node, Map<String, ?> prefixMap) {
        new InnerConfigurationSource(prefixMap).descend(node);
    }

    public static <K> List<K> appendKey(List<K> prefix, K key) {
        if (prefix.isEmpty()) {
            return List.of(key);
        }
        ArrayList<K> res = new ArrayList<K>(prefix.size() + 1);
        res.addAll(prefix);
        res.add(key);
        return res;
    }

    public static void addDefaults(final InnerNode node) {
        node.traverseChildren(new ConfigurationVisitor<Object>(){

            @Override
            public Object visitLeafNode(Field field, String key, Serializable val) {
                if (val == null) {
                    node.constructDefault(key);
                }
                return null;
            }

            @Override
            public Object visitInnerNode(Field field, String key, InnerNode innerNode) {
                node.construct(key, EMPTY_CFG_SRC, true);
                InnerNode childNode = node.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                ConfigurationUtil.addDefaults(childNode);
                return null;
            }

            @Override
            public Object visitNamedListNode(Field field, String key, NamedListNode<?> namedList) {
                node.construct(key, EMPTY_CFG_SRC, true);
                namedList = node.traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
                for (String namedListKey : namedList.namedListKeys()) {
                    if (namedList.getInnerNode(namedListKey) == null) continue;
                    namedList.construct(namedListKey, EMPTY_CFG_SRC, true);
                    ConfigurationUtil.addDefaults(namedList.getInnerNode(namedListKey));
                }
                return null;
            }
        }, true);
    }

    public static void dropNulls(InnerNode node) {
        node.traverseChildren(new ConfigurationVisitor<Object>(){

            @Override
            public Object visitInnerNode(Field field, String key, InnerNode innerNode) {
                ConfigurationUtil.dropNulls(innerNode);
                return null;
            }

            @Override
            public Object visitNamedListNode(Field field, String key, NamedListNode<?> namedList) {
                for (String namedListKey : namedList.namedListKeys()) {
                    InnerNode element = namedList.getInnerNode(namedListKey);
                    if (element == null) {
                        namedList.forceDelete(namedListKey);
                        continue;
                    }
                    ConfigurationUtil.dropNulls(element);
                }
                return null;
            }
        }, true);
    }

    public static ConfigurationVisitor<Serializable> leafNodeVisitor() {
        return new ConfigurationVisitor<Serializable>(){

            @Override
            public Serializable visitLeafNode(Field field, String key, Serializable val) {
                return val;
            }
        };
    }

    public static ConfigurationVisitor<InnerNode> innerNodeVisitor() {
        return new ConfigurationVisitor<InnerNode>(){

            @Override
            public InnerNode visitInnerNode(Field field, String key, InnerNode node) {
                return node;
            }
        };
    }

    public static ConfigurationVisitor<NamedListNode<?>> namedListNodeVisitor() {
        return new ConfigurationVisitor<NamedListNode<?>>(){

            @Override
            public NamedListNode<?> visitNamedListNode(Field field, String key, NamedListNode<?> node) {
                return node;
            }
        };
    }

    public static void checkConfigurationType(Collection<RootKey<?, ?, ?>> rootKeys, ConfigurationStorage storage) {
        for (RootKey<?, ?, ?> key : rootKeys) {
            if (key.type() == storage.type()) continue;
            throw new IllegalArgumentException("Invalid root key configuration type [key=" + key + ", storage=" + storage.getClass().getName() + ", storageType=" + storage.type() + "]");
        }
    }

    public static boolean isValue(Field schemaField) {
        return schemaField.isAnnotationPresent(Value.class) || schemaField.isAnnotationPresent(InjectedValue.class);
    }

    public static boolean isConfigValue(Field schemaField) {
        return schemaField.isAnnotationPresent(ConfigValue.class);
    }

    public static boolean isNamedConfigValue(Field schemaField) {
        return schemaField.isAnnotationPresent(NamedConfigValue.class);
    }

    public static boolean isInternalId(Field schemaField) {
        return schemaField.isAnnotationPresent(InternalId.class);
    }

    public static String syntheticKeyName(Field field) {
        assert (ConfigurationUtil.isNamedConfigValue(field)) : field;
        return field.getAnnotation(NamedConfigValue.class).syntheticKeyName();
    }

    public static boolean hasDefault(Field field) {
        assert (ConfigurationUtil.isValue(field)) : field;
        InjectedValue injectedValue = field.getAnnotation(InjectedValue.class);
        if (injectedValue != null) {
            return injectedValue.hasDefault();
        }
        return field.getAnnotation(Value.class).hasDefault();
    }

    public static Set<Class<?>> collectSchemas(Iterable<Class<?>> schemaClasses) {
        HashSet res = new HashSet();
        ArrayDeque queue = new ArrayDeque();
        schemaClasses.forEach(queue::add);
        while (!queue.isEmpty()) {
            Class cls = (Class)queue.poll();
            if (!(cls.isAnnotationPresent(ConfigurationRoot.class) || cls.isAnnotationPresent(Config.class) || cls.isAnnotationPresent(ConfigurationExtension.class) || cls.isAnnotationPresent(PolymorphicConfig.class) || cls.isAnnotationPresent(PolymorphicConfigInstance.class) || cls.isAnnotationPresent(AbstractConfiguration.class))) {
                throw new IllegalArgumentException(String.format("Configuration schema must contain one of @%s, @%s, @%s, @%s, @%s, @%s: %s", ConfigurationRoot.class.getSimpleName(), Config.class.getSimpleName(), ConfigurationExtension.class.getSimpleName(), PolymorphicConfig.class.getSimpleName(), PolymorphicConfigInstance.class.getSimpleName(), AbstractConfiguration.class.getSimpleName(), cls.getName()));
            }
            res.add(cls);
            Class superclass = cls.getSuperclass();
            if (superclass.isAnnotationPresent(AbstractConfiguration.class) && !res.contains(superclass)) {
                queue.add(superclass);
            }
            for (Field f : cls.getDeclaredFields()) {
                if (!f.isAnnotationPresent(ConfigValue.class) && !f.isAnnotationPresent(NamedConfigValue.class) || res.contains(f.getType())) continue;
                queue.add(f.getType());
            }
        }
        return res;
    }

    public static List<String> classNames(Field ... fields) {
        return Stream.of(fields).map(Field::getDeclaringClass).map(Class::getName).collect(Collectors.toList());
    }

    public static Map<Class<?>, Set<Class<?>>> polymorphicSchemaExtensions(Collection<Class<?>> extensions) {
        return ConfigurationUtil.schemaExtensions(extensions, PolymorphicConfigInstance.class);
    }

    public static Map<Class<?>, Set<Class<?>>> schemaExtensions(Collection<Class<?>> extensions) {
        return ConfigurationUtil.schemaExtensions(extensions, ConfigurationExtension.class);
    }

    private static Map<Class<?>, Set<Class<?>>> schemaExtensions(Collection<Class<?>> extensions, Class<? extends Annotation> annotationClass) {
        if (extensions.isEmpty()) {
            return Map.of();
        }
        HashMap res = new HashMap();
        for (Class<?> extension : extensions) {
            if (!extension.isAnnotationPresent(annotationClass)) {
                throw new IllegalArgumentException(String.format("Extension should contain @%s: %s", annotationClass.getSimpleName(), extension.getName()));
            }
            res.computeIfAbsent(extension.getSuperclass(), cls -> new HashSet()).add(extension);
        }
        return res;
    }

    public static List<Field> schemaFields(Class<?> schemaClass) {
        return Arrays.stream(schemaClass.getDeclaredFields()).filter(f -> ConfigurationUtil.isValue(f) || ConfigurationUtil.isConfigValue(f) || ConfigurationUtil.isNamedConfigValue(f) || ConfigurationUtil.isPolymorphicId(f) || ConfigurationUtil.isInjectedName(f)).collect(Collectors.toList());
    }

    public static Collection<Field> extensionsFields(Collection<Class<?>> extensions, boolean uniqueByName) {
        if (extensions.isEmpty()) {
            return List.of();
        }
        if (uniqueByName) {
            return extensions.stream().flatMap(cls -> Arrays.stream(cls.getDeclaredFields())).filter(f -> ConfigurationUtil.isValue(f) || ConfigurationUtil.isConfigValue(f) || ConfigurationUtil.isNamedConfigValue(f) || ConfigurationUtil.isPolymorphicId(f)).collect(Collectors.toMap(Field::getName, Function.identity(), (f1, f2) -> {
                throw new IllegalArgumentException(String.format("Duplicate field names are not allowed [field=%s, classes=%s]", f1.getName(), ConfigurationUtil.classNames(f1, f2)));
            }, LinkedHashMap::new)).values();
        }
        return extensions.stream().flatMap(cls -> Arrays.stream(cls.getDeclaredFields())).filter(f -> ConfigurationUtil.isValue(f) || ConfigurationUtil.isConfigValue(f) || ConfigurationUtil.isNamedConfigValue(f) || ConfigurationUtil.isPolymorphicId(f)).collect(Collectors.toList());
    }

    public static boolean isInternalExtension(Class<?> schemaClass) {
        ConfigurationExtension ext = schemaClass.getAnnotation(ConfigurationExtension.class);
        return ext != null && ext.internal();
    }

    public static boolean isPublicExtension(Class<?> schemaClass) {
        ConfigurationExtension ext = schemaClass.getAnnotation(ConfigurationExtension.class);
        return ext != null && !ext.internal();
    }

    public static boolean isPolymorphicId(Field schemaField) {
        return schemaField.isAnnotationPresent(PolymorphicId.class);
    }

    public static boolean isPolymorphicConfig(Class<?> schemaClass) {
        return schemaClass.isAnnotationPresent(PolymorphicConfig.class);
    }

    public static boolean isPolymorphicConfigInstance(Class<?> schemaClass) {
        return schemaClass.isAnnotationPresent(PolymorphicConfigInstance.class);
    }

    public static String polymorphicInstanceId(Class<?> schemaClass) {
        assert (ConfigurationUtil.isPolymorphicConfigInstance(schemaClass)) : schemaClass.getName();
        return schemaClass.getAnnotation(PolymorphicConfigInstance.class).value();
    }

    public static void compressDeletedEntries(Map<String, ?> prefixMap) {
        for (Map.Entry<String, ?> entry : prefixMap.entrySet()) {
            Map map;
            Object value = entry.getValue();
            if (!(value instanceof Map) || !(map = (Map)value).containsKey("<name>") || map.get("<name>") != null) continue;
            entry.setValue(null);
        }
        for (Map.Entry<String, Object> value : prefixMap.values()) {
            if (!(value instanceof Map)) continue;
            ConfigurationUtil.compressDeletedEntries((Map)((Object)value));
        }
    }

    @Nullable
    public static <T> T findEx(final List<KeyPathNode> path, InnerNode rootNode) {
        try {
            ConfigurationVisitor visitor = new ConfigurationVisitor<T>(){
                private final int pathSize;
                private int idx;
                {
                    this.pathSize = path.size();
                }

                @Override
                public T visitLeafNode(Field field, String key, Serializable val) {
                    if (this.idx != this.pathSize) {
                        throw new KeyNotFoundException("Configuration value '" + ConfigurationUtil.joinPath(path.subList(0, this.idx)) + "' is a leaf");
                    }
                    return val;
                }

                @Override
                public T visitInnerNode(Field field, String key, InnerNode node) {
                    if (node == null) {
                        throw new KeyNotFoundException("Configuration node '" + ConfigurationUtil.joinPath(path.subList(0, this.idx)) + "' is null");
                    }
                    if (this.idx == this.pathSize) {
                        return node;
                    }
                    try {
                        KeyPathNode pathNode = (KeyPathNode)path.get(this.idx++);
                        assert (!pathNode.unresolvedName);
                        if ("<internal_id>".equals(pathNode.key)) {
                            return node.internalId();
                        }
                        if ("<injected_name>".equals(pathNode.key)) {
                            return node.getInjectedNameFieldValue();
                        }
                        return node.traverseChild(pathNode.key, this, true);
                    }
                    catch (NoSuchElementException e) {
                        throw new KeyNotFoundException("Configuration value '" + ConfigurationUtil.joinPath(path.subList(0, this.idx)) + "' has not been found");
                    }
                    catch (ConfigurationWrongPolymorphicTypeIdException e) {
                        assert (false) : e;
                        return null;
                    }
                }

                @Override
                public T visitNamedListNode(Field field, String key, NamedListNode<?> node) {
                    if (this.idx == this.pathSize) {
                        return node;
                    }
                    KeyPathNode pathNode = (KeyPathNode)path.get(this.idx++);
                    assert (pathNode.namedListEntry);
                    if (!pathNode.unresolvedName && "<internal_ids>".equals(pathNode.key)) {
                        return List.copyOf(node.internalIds());
                    }
                    String name = pathNode.unresolvedName ? pathNode.key : node.keyByInternalId(UUID.fromString(pathNode.key));
                    return this.visitInnerNode(field, name, node.getInnerNode(name));
                }
            };
            return rootNode.accept(null, null, visitor);
        }
        catch (KeyNotFoundException e) {
            throw new NoSuchElementException(ConfigurationUtil.joinPath(path));
        }
    }

    private static String joinPath(List<KeyPathNode> path) {
        return path.stream().map(pathNode -> pathNode.key).map(ConfigurationUtil::escape).collect(Collectors.joining(KEY_SEPARATOR));
    }

    public static void touch(DynamicConfiguration<?, ?> cfg) {
        cfg.touchMembers();
        for (ConfigurationProperty<?> value : cfg.members().values()) {
            if (!(value instanceof DynamicConfiguration)) continue;
            ConfigurationUtil.touch((DynamicConfiguration)value);
        }
    }

    public static <T1, T2> Iterable<T2> mapIterable(@Nullable Iterable<? extends T1> iterable, final @Nullable Function<? super T1, ? extends T2> mapper) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        if (mapper == null) {
            return iterable;
        }
        return () -> {
            final Iterator innerIterator = iterable.iterator();
            return new Iterator<T2>(){
                @Nullable
                private T2 next;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    while (innerIterator.hasNext()) {
                        this.next = mapper.apply(innerIterator.next());
                        if (this.next == null) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public T2 next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.next;
                    this.next = null;
                    return result;
                }
            };
        };
    }

    public static void ignoreLegacyKeys(SuperRoot roots, final Map<String, ?> prefixMap) {
        roots.traverseChildren(new KeysTrackingConfigurationVisitor<Object>(){
            private Map<String, ?> currentMap;
            {
                this.currentMap = prefixMap;
            }

            @Override
            protected Object doVisitLegacyLeafNode(Field field, String key, Serializable val, boolean isDeprecated) {
                if (!isDeprecated) {
                    this.currentMap.remove(key);
                }
                return null;
            }

            @Override
            protected Object doVisitInnerNode(Field field, String key, InnerNode node) {
                if (!this.currentMap.containsKey(key)) {
                    return null;
                }
                Map<String, ?> prev = this.currentMap;
                this.currentMap = (Map)this.currentMap.get(key);
                node.traverseChildren(this, true);
                this.currentMap = prev;
                return null;
            }

            @Override
            protected Object doVisitLegacyInnerNode(Field field, String key, InnerNode node, boolean isDeprecated) {
                this.currentMap.remove(key);
                return null;
            }

            @Override
            protected Object doVisitNamedListNode(Field field, String key, NamedListNode<?> node) {
                if (!this.currentMap.containsKey(key)) {
                    return null;
                }
                Map<String, ?> prev = this.currentMap;
                this.currentMap = (Map)this.currentMap.get(key);
                for (String namedListKey : node.namedListKeys()) {
                    this.withTracking(field, node.internalId(namedListKey).toString(), false, false, () -> {
                        this.doVisitInnerNode(field, namedListKey, node.getInnerNode(namedListKey));
                        return null;
                    });
                }
                this.currentMap = prev;
                return null;
            }

            @Override
            protected Object doVisitLegacyNamedListNode(Field field, String key, NamedListNode<?> node, boolean isDeprecated) {
                this.currentMap.remove(key);
                return null;
            }
        }, true);
    }

    public static boolean isInjectedName(Field schemaField) {
        return schemaField.isAnnotationPresent(InjectedName.class);
    }

    public static boolean isInjectedValue(Field schemaField) {
        return schemaField.isAnnotationPresent(InjectedValue.class);
    }

    public static boolean isReadOnly(Field schemaField) {
        return ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField) || ConfigurationUtil.isInternalId(schemaField);
    }

    public static boolean containsNameAnnotation(Field schemaField) {
        return schemaField.isAnnotationPresent(Name.class);
    }

    public static List<String> removeLastKey(List<String> keys) {
        if (keys.isEmpty() || keys.size() == 1) {
            return List.of();
        }
        return List.copyOf(keys.subList(0, keys.size() - 1));
    }

    public static UUID internalId(NamedListView<?> node, String name) {
        return ((NamedListNode)node).internalId(name);
    }

    private static class InnerConfigurationSource
    implements ConfigurationSource {
        private final Map<String, ?> map;

        private InnerConfigurationSource(Map<String, ?> map) {
            this.map = map;
        }

        @Override
        public void descend(ConstructableTreeNode node) {
            if (node instanceof NamedListNode) {
                this.descendToNamedListNode((NamedListNode)node);
                return;
            }
            assert (node instanceof InnerNode) : node;
            for (Map.Entry<String, ?> entry : this.map.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                assert (val == null || val instanceof Map || val instanceof Serializable);
                if (key.equals("<order>") || key.equals("<name>")) continue;
                if (val == null) {
                    try {
                        ((InnerNode)node).constructDefault(key);
                        continue;
                    }
                    catch (NoSuchElementException ignore) {
                        assert (((InnerNode)node).isPolymorphic()) : "Constructing property " + key + " failed in " + node + " and it is not polymorphic.";
                        continue;
                    }
                }
                if (val instanceof Map) {
                    node.construct(key, new InnerConfigurationSource((Map)val), true);
                    continue;
                }
                node.construct(key, new LeafConfigurationSource((Serializable)val), true);
            }
        }

        @Override
        @Nullable
        public String polymorphicTypeId(String fieldName) {
            return (String)this.map.get(fieldName);
        }

        private void descendToNamedListNode(NamedListNode<?> node) {
            ArrayList<String> orderedKeys = new ArrayList<String>(node.namedListKeys());
            for (Map.Entry<String, ?> entry : this.map.entrySet()) {
                String internalIdStr = entry.getKey();
                if ("<ids>".equals(internalIdStr)) continue;
                UUID internalId = UUID.fromString(internalIdStr);
                Object val = entry.getValue();
                assert (val == null || val instanceof Map || val instanceof Serializable);
                String oldKey = node.keyByInternalId(internalId);
                if (val == null) {
                    node.forceDelete(oldKey);
                    continue;
                }
                if (val instanceof Map) {
                    boolean construct;
                    String newKey;
                    Map map = (Map)val;
                    int sizeDiff = 0;
                    Object idxObj = map.get("<order>");
                    if (idxObj != null) {
                        ++sizeDiff;
                    }
                    if ((newKey = (String)map.get("<name>")) != null) {
                        ++sizeDiff;
                    }
                    boolean bl = construct = map.size() != sizeDiff;
                    if (oldKey == null) {
                        node.construct(newKey, new InnerConfigurationSource(map), true);
                        node.setInternalId(newKey, internalId);
                    } else if (newKey != null) {
                        node.rename(oldKey, newKey);
                        if (construct) {
                            node.construct(newKey, new InnerConfigurationSource(map), true);
                        }
                    } else if (construct) {
                        node.construct(oldKey, new InnerConfigurationSource(map), true);
                    }
                    if (newKey == null) {
                        newKey = oldKey;
                    }
                    if (idxObj == null) continue;
                    assert (idxObj instanceof Integer) : val;
                    int idx = (Integer)idxObj;
                    if (idx >= orderedKeys.size()) {
                        orderedKeys.ensureCapacity(idx + 1);
                        while (idx != orderedKeys.size()) {
                            orderedKeys.add(null);
                        }
                        orderedKeys.add(newKey);
                        continue;
                    }
                    orderedKeys.set(idx, newKey);
                    continue;
                }
                node.construct(oldKey, new LeafConfigurationSource((Serializable)val), true);
            }
            orderedKeys.removeIf(Objects::isNull);
            node.reorderKeys(orderedKeys.size() > node.size() ? orderedKeys.subList(0, node.size()) : orderedKeys);
        }
    }

    public static class LeafConfigurationSource
    implements ConfigurationSource {
        private final Serializable val;

        public LeafConfigurationSource(Serializable val) {
            this.val = val;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            assert (this.val == null || clazz.isInstance(this.val));
            return clazz.cast(this.val);
        }

        @Override
        public void descend(ConstructableTreeNode node) {
            throw new UnsupportedOperationException("descend");
        }
    }
}

