/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.hocon;

import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.configuration.KeyIgnorer;
import org.apache.ignite.internal.configuration.TypeUtils;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;

class HoconPrimitiveConfigurationSource
implements ConfigurationSource {
    private final List<String> path;
    private final ConfigValue hoconCfgValue;
    private final KeyIgnorer keyIgnorer;

    HoconPrimitiveConfigurationSource(KeyIgnorer keyIgnorer, List<String> path, ConfigValue hoconCfgValue) {
        assert (!path.isEmpty());
        this.path = path;
        this.hoconCfgValue = hoconCfgValue;
        this.keyIgnorer = keyIgnorer;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isArray()) {
            throw HoconPrimitiveConfigurationSource.wrongTypeException(clazz, this.path, -1);
        }
        return HoconPrimitiveConfigurationSource.unwrapPrimitive(this.hoconCfgValue, clazz, this.path, -1);
    }

    @Override
    public void descend(ConstructableTreeNode node) {
        String fieldName = node.injectedValueFieldName();
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("'%s' is expected to be a composite configuration node, not a single value", ConfigurationUtil.join(this.path)));
        }
        if (this.keyIgnorer.shouldIgnore(ConfigurationUtil.join(ConfigurationUtil.appendKey(this.path, fieldName)))) {
            return;
        }
        node.construct(fieldName, this, false);
    }

    public static IllegalArgumentException wrongTypeException(Class<?> clazz, List<String> path, int idx) {
        return new IllegalArgumentException(String.format("'%s' is expected as a type for the '%s' configuration value", HoconPrimitiveConfigurationSource.unbox(clazz).getSimpleName(), HoconPrimitiveConfigurationSource.formatArrayPath(path, idx)));
    }

    private static Class<?> unbox(Class<?> clazz) {
        assert (!clazz.isPrimitive());
        Class<?> unboxed = TypeUtils.unboxed(clazz);
        return unboxed == null ? clazz : unboxed;
    }

    public static <T> T unwrapPrimitive(ConfigValue hoconCfgValue, Class<T> clazz, List<String> path, int idx) {
        assert (!clazz.isArray());
        assert (!clazz.isPrimitive());
        if (clazz == String.class) {
            String stringValue = HoconPrimitiveConfigurationSource.unwrapStringValue(hoconCfgValue);
            return clazz.cast(stringValue);
        }
        if (clazz == Boolean.class) {
            if (hoconCfgValue.valueType() != ConfigValueType.BOOLEAN) {
                throw HoconPrimitiveConfigurationSource.wrongTypeException(clazz, path, idx);
            }
            return clazz.cast(hoconCfgValue.unwrapped());
        }
        if (clazz == Character.class) {
            String stringValue = HoconPrimitiveConfigurationSource.unwrapStringValue(hoconCfgValue);
            if (stringValue.length() != 1) {
                throw HoconPrimitiveConfigurationSource.wrongTypeException(clazz, path, idx);
            }
            return clazz.cast(Character.valueOf(stringValue.charAt(0)));
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (hoconCfgValue.valueType() != ConfigValueType.NUMBER) {
                throw HoconPrimitiveConfigurationSource.wrongTypeException(clazz, path, idx);
            }
            Number numberValue = (Number)hoconCfgValue.unwrapped();
            if (clazz == Byte.class) {
                HoconPrimitiveConfigurationSource.checkBounds(numberValue, -128L, 127L, path, idx);
                return clazz.cast(numberValue.byteValue());
            }
            if (clazz == Short.class) {
                HoconPrimitiveConfigurationSource.checkBounds(numberValue, -32768L, 32767L, path, idx);
                return clazz.cast(numberValue.shortValue());
            }
            if (clazz == Integer.class) {
                HoconPrimitiveConfigurationSource.checkBounds(numberValue, Integer.MIN_VALUE, Integer.MAX_VALUE, path, idx);
                return clazz.cast(numberValue.intValue());
            }
            if (clazz == Long.class) {
                return clazz.cast(numberValue.longValue());
            }
            if (clazz == Float.class) {
                return clazz.cast(Float.valueOf(numberValue.floatValue()));
            }
            if (clazz == Double.class) {
                return clazz.cast(numberValue.doubleValue());
            }
        } else if (clazz == UUID.class) {
            if (hoconCfgValue.valueType() != ConfigValueType.STRING) {
                throw HoconPrimitiveConfigurationSource.wrongTypeException(clazz, path, idx);
            }
            return clazz.cast(UUID.fromString(hoconCfgValue.unwrapped().toString()));
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz);
    }

    private static String unwrapStringValue(ConfigValue hoconCfgValue) {
        return hoconCfgValue.valueType() == ConfigValueType.STRING ? hoconCfgValue.unwrapped().toString() : hoconCfgValue.render();
    }

    private static void checkBounds(Number numberValue, long lower, long upper, List<String> path, int idx) {
        long longValue = numberValue.longValue();
        if (longValue < lower || longValue > upper) {
            throw new IllegalArgumentException(String.format("Value '%d' of '%s' is out of its declared bounds: [%d : %d]", longValue, HoconPrimitiveConfigurationSource.formatArrayPath(path, idx), lower, upper));
        }
    }

    public static String formatArrayPath(List<String> path, int idx) {
        return ConfigurationUtil.join(path) + (String)(idx == -1 ? "" : "[" + idx + "]");
    }
}

