/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.SystemLocalExtensionChange;
import org.apache.ignite.internal.configuration.SystemLocalExtensionConfiguration;
import org.apache.ignite.internal.configuration.SystemLocalExtensionConfigurationSchema;
import org.apache.ignite.internal.configuration.SystemLocalExtensionView;
import org.apache.ignite.internal.configuration.ThreadPoolsExtensionConfigurationSchema;
import org.apache.ignite.internal.worker.configuration.CriticalWorkersChange;
import org.apache.ignite.internal.worker.configuration.CriticalWorkersView;

@AutoService(value={ConfigurationModule.class})
public class SystemLocalConfigurationModule
implements ConfigurationModule {
    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(SystemLocalExtensionConfigurationSchema.class, ThreadPoolsExtensionConfigurationSchema.class);
    }

    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        SystemLocalExtensionView rootView = (SystemLocalExtensionView)superRootChange.viewRoot(SystemLocalExtensionConfiguration.KEY);
        SystemLocalExtensionChange rootChange = (SystemLocalExtensionChange)superRootChange.changeRoot(SystemLocalExtensionConfiguration.KEY);
        CriticalWorkersView criticalWorkersView = rootView.criticalWorkers();
        CriticalWorkersChange criticalWorkersChange = rootChange.changeSystem().changeCriticalWorkers();
        if (criticalWorkersView.livenessCheckIntervalMillis() != 2000L) {
            criticalWorkersChange.changeLivenessCheckIntervalMillis(criticalWorkersView.livenessCheckIntervalMillis());
        }
        if (criticalWorkersView.maxAllowedLagMillis() != 5000L) {
            criticalWorkersChange.changeMaxAllowedLagMillis(criticalWorkersView.maxAllowedLagMillis());
        }
        if (criticalWorkersView.nettyThreadsHeartbeatIntervalMillis() != 1000L) {
            criticalWorkersChange.changeNettyThreadsHeartbeatIntervalMillis(criticalWorkersView.nettyThreadsHeartbeatIntervalMillis());
        }
    }
}

