/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.storage;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.KeyIgnorer;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.ConfigurationDynamicDefaultsPatcherImpl;
import org.apache.ignite.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite.internal.configuration.NodeConfigCreateException;
import org.apache.ignite.internal.configuration.NodeConfigParseException;
import org.apache.ignite.internal.configuration.NodeConfigWriteException;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.ConverterToMapVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationFlattener;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.validation.ConfigurationDuplicatesValidator;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LocalFileConfigurationStorage
implements ConfigurationStorage {
    private static final IgniteLogger LOG = Loggers.forClass(LocalFileConfigurationStorage.class);
    private final Path configPath;
    private final Path tempConfigPath;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Serializable> latest = new ConcurrentHashMap<String, Serializable>();
    private final ConfigurationTreeGenerator generator;
    private final ConfigurationModule module;
    private final AtomicReference<ConfigurationStorageListener> lsnrRef = new AtomicReference();
    private final ExecutorService notificationsThreadPool;
    private final InFlightFutures futureTracker = new InFlightFutures();
    private long lastRevision = 0L;

    @TestOnly
    public LocalFileConfigurationStorage(Path configPath, ConfigurationTreeGenerator generator, @Nullable ConfigurationModule module) {
        this("test", configPath, generator, module);
    }

    public LocalFileConfigurationStorage(String nodeName, Path configPath, ConfigurationTreeGenerator generator, @Nullable ConfigurationModule module) {
        this.configPath = configPath;
        this.generator = generator;
        this.tempConfigPath = configPath.resolveSibling(String.valueOf(configPath.getFileName()) + ".tmp");
        this.module = module;
        this.notificationsThreadPool = Executors.newFixedThreadPool(2, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"cfg-file", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
        this.checkAndRestoreConfigFile();
    }

    private String patch(String hocon, ConfigurationModule module) {
        if (module == null) {
            return hocon;
        }
        ConfigurationDynamicDefaultsPatcherImpl localCfgDynamicDefaultsPatcher = new ConfigurationDynamicDefaultsPatcherImpl(module, this.generator);
        return localCfgDynamicDefaultsPatcher.patchWithDynamicDefaults(hocon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Data> readDataOnRecovery() {
        this.lock.writeLock().lock();
        try {
            String hocon = this.readHoconFromFile();
            String hoconWithDynamicDefaults = this.patch(hocon, this.module);
            this.transformToMap(hocon).forEach((key, value) -> {
                if (value != null) {
                    this.latest.put((String)key, (Serializable)value);
                }
            });
            CompletableFuture<Data> completableFuture = CompletableFuture.completedFuture(new Data(this.transformToMap(hoconWithDynamicDefaults), this.lastRevision));
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Map<String, Serializable> transformToMap(String hocon) {
        SuperRoot superRoot = this.generator.createSuperRoot();
        SuperRoot copiedSuperRoot = superRoot.copy();
        KeyIgnorer keyIgnorer = this.module == null ? s -> false : KeyIgnorer.fromDeletedPrefixes((Collection)this.module.deletedPrefixes());
        HoconConverter.hoconSource((ConfigObject)this.parseConfig(hocon).root(), (KeyIgnorer)keyIgnorer).descend((ConstructableTreeNode)copiedSuperRoot);
        return ConfigurationFlattener.createFlattenedUpdatesMap((SuperRoot)superRoot, (SuperRoot)copiedSuperRoot, Collections.emptyNavigableMap()).entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String readHoconFromFile() {
        this.checkAndRestoreConfigFile();
        try {
            String confString = Files.readString(this.configPath.toAbsolutePath());
            Collection duplicates = ConfigurationDuplicatesValidator.validate((String)confString);
            if (!duplicates.isEmpty()) {
                throw new ConfigurationValidationException(duplicates);
            }
            return confString;
        }
        catch (ConfigException.Parse | IOException e) {
            throw new NodeConfigParseException("Failed to parse config content from file " + String.valueOf(this.configPath), e);
        }
    }

    private Config parseConfig(String confString) {
        try {
            ConfigParseOptions parseOptions = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF).setAllowMissing(false);
            return ConfigFactory.parseString((String)confString, (ConfigParseOptions)parseOptions);
        }
        catch (ConfigException.Parse e) {
            throw new NodeConfigParseException("Failed to parse config content from file " + String.valueOf(this.configPath), e);
        }
    }

    public CompletableFuture<Map<String, ? extends Serializable>> readAllLatest(String prefix) {
        this.lock.readLock().lock();
        try {
            CompletableFuture<Map<String, ? extends Serializable>> completableFuture = CompletableFuture.completedFuture(this.latest.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            return completableFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompletableFuture<Serializable> readLatest(String key) {
        this.lock.readLock().lock();
        try {
            CompletableFuture<Serializable> completableFuture = CompletableFuture.completedFuture(this.latest.get(key));
            return completableFuture;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> write(Map<String, ? extends Serializable> newValues, long ver) {
        this.lock.writeLock().lock();
        try {
            if (ver != this.lastRevision) {
                CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
                return completableFuture;
            }
            this.mergeAndSave(newValues);
            this.sendNotificationAsync(new Data(newValues, this.lastRevision));
            CompletableFuture completableFuture = CompletableFutures.trueCompletedFuture();
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void mergeAndSave(Map<String, ? extends Serializable> newValues) {
        this.updateLatestState(newValues);
        this.saveConfigFile();
        ++this.lastRevision;
    }

    private void updateLatestState(Map<String, ? extends Serializable> newValues) {
        newValues.forEach((key, value) -> {
            if (value == null) {
                this.latest.remove(key);
            } else {
                this.latest.put((String)key, (Serializable)value);
            }
        });
    }

    public void registerConfigurationListener(ConfigurationStorageListener lsnr) {
        if (!this.lsnrRef.compareAndSet(null, lsnr)) {
            LOG.debug("Configuration listener has already been set", new Object[0]);
        }
    }

    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    public CompletableFuture<Long> lastRevision() {
        return CompletableFuture.completedFuture(this.lastRevision);
    }

    public CompletableFuture<Long> localRevision() {
        return this.lastRevision();
    }

    public void close() {
        this.futureTracker.cancelInFlightFutures();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.notificationsThreadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public boolean supportDefaults() {
        return false;
    }

    private void saveConfigFile() {
        if (!Files.isWritable(this.configPath)) {
            NodeConfigWriteException e = new NodeConfigWriteException("The configuration file is read-only, so changes cannot be applied. Check your system configuration. If you are using containerization, such as Kubernetes, the file can only be modified through native Kubernetes methods.");
            LOG.warn("The config file " + String.valueOf(this.configPath) + " is not writable", (Throwable)((Object)e));
            throw e;
        }
        try {
            Files.write(this.tempConfigPath, this.renderHoconString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.SYNC, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.move(this.tempConfigPath, this.configPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.error("Failed to write values to config file.", (Throwable)e);
            throw new NodeConfigWriteException("Failed to write values to config file.", e);
        }
    }

    private String renderHoconString() {
        SuperRoot rootNode = this.generator.createSuperRoot();
        ConfigurationUtil.fillFromPrefixMap((InnerNode)rootNode, (Map)ConfigurationUtil.toPrefixMap(this.latest));
        Object transformed = rootNode.accept(null, null, (ConfigurationVisitor)ConverterToMapVisitor.builder().includeInternal(false).includeDeprecated(false).skipEmptyValues(true).maskSecretValues(false).build());
        ConfigValue conf = ConfigImpl.fromAnyRef((Object)transformed, null);
        return LocalFileConfigurationStorage.renderConfig((ConfigObject)conf);
    }

    private static String renderConfig(ConfigObject conf) {
        Config newConfig = conf.toConfig().resolve();
        return newConfig.isEmpty() ? "" : newConfig.root().render(ConfigRenderOptions.concise().setFormatted(true).setJson(false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndRestoreConfigFile() {
        if (Files.notExists(this.configPath, new LinkOption[0])) {
            try {
                Files.createFile(this.configPath, new FileAttribute[0]);
                if (this.latest.isEmpty()) return;
                this.saveConfigFile();
                return;
            }
            catch (FileAlreadyExistsException e) {
                throw new NodeConfigCreateException("Failed to re-create config file.", e);
            }
            catch (IOException e) {
                throw new NodeConfigWriteException("Failed to restore config file.", e);
            }
        } else {
            if (Files.isWritable(this.configPath)) return;
            LOG.warn("Configuration file '{}' is read-only. All dynamic configuration updates will be lost after node restart.", new Object[]{this.configPath});
        }
    }

    private void sendNotificationAsync(Data data) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.lsnrRef.get().onEntriesChanged(data), this.notificationsThreadPool);
        this.futureTracker.registerFuture(future);
    }
}

