/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import javax.annotation.processing.ProcessingEnvironment;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.ConfigurationExtension;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class ConfigurationRootValidator
extends Validator {
    public ConfigurationRootValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        if (classWrapper.getAnnotation(ConfigurationRoot.class) == null) {
            return;
        }
        ConfigurationRootValidator.assertHasCompatibleTopLevelAnnotation(classWrapper, ConfigurationRoot.class, ConfigurationExtension.class);
        ConfigurationRootValidator.assertNotContainsFieldAnnotatedWith(classWrapper, PolymorphicId.class);
        ClassWrapper superClass = classWrapper.superClass();
        if (superClass == null) {
            return;
        }
        ConfigurationRootValidator.assertSuperclassHasAnnotations(classWrapper, AbstractConfiguration.class);
        ConfigurationRootValidator.assertNoFieldNameConflictsWithSuperClass(classWrapper);
        ConfigurationRootValidator.assertSuperClassNotContainsFieldAnnotatedWith(classWrapper, InjectedName.class, InternalId.class);
    }
}

