/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import javax.annotation.processing.ProcessingEnvironment;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigurationExtension;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class ConfigurationExtentionValidator
extends Validator {
    public ConfigurationExtentionValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        if (classWrapper.getAnnotation(ConfigurationExtension.class) == null) {
            return;
        }
        ConfigurationExtentionValidator.assertHasCompatibleTopLevelAnnotation(classWrapper, ConfigurationExtension.class, ConfigurationRoot.class, Config.class);
        ConfigurationExtentionValidator.assertNotContainsFieldAnnotatedWith(classWrapper, PolymorphicId.class);
        if (classWrapper.getAnnotation(ConfigurationRoot.class) == null) {
            ConfigurationExtentionValidator.assertHasSuperClass(classWrapper);
            ConfigurationExtentionValidator.assertSuperclassHasAnnotations(classWrapper, ConfigurationRoot.class, Config.class);
            ConfigurationExtentionValidator.assertNoFieldNameConflictsWithSuperClass(classWrapper);
        } else {
            ConfigurationExtentionValidator.assertHasNoSuperClass(classWrapper);
        }
    }
}

