/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessor;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;

public abstract class Validator {
    final ProcessingEnvironment processingEnvironment;

    Validator(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
    }

    public abstract void validate(ClassWrapper var1) throws ConfigurationValidationException;

    @SafeVarargs
    static void assertNotContainsFieldAnnotatedWith(ClassWrapper classWrapper, Class<? extends Annotation> ... annotations) {
        if (ConfigurationProcessorUtils.containsAnyAnnotation(classWrapper.fields(), annotations)) {
            throw new ConfigurationValidationException(classWrapper, String.format("Must not have fields annotated with %s.", ConfigurationProcessorUtils.joinSimpleName(" or ", annotations)));
        }
    }

    @SafeVarargs
    static void assertSuperClassNotContainsFieldAnnotatedWith(ClassWrapper classWrapper, Class<? extends Annotation> ... annotations) {
        if (ConfigurationProcessorUtils.containsAnyAnnotation(classWrapper.requiredSuperClass().fields(), annotations)) {
            throw new ConfigurationValidationException(classWrapper, String.format("Superclass %s must not have fields annotated with %s.", classWrapper.requiredSuperClass(), ConfigurationProcessorUtils.joinSimpleName(" or ", annotations)));
        }
    }

    static void assertHasSuperClass(ClassWrapper classWrapper) {
        if (classWrapper.superClass() == null) {
            throw new ConfigurationValidationException(classWrapper, "Must have a superclass.");
        }
    }

    static void assertHasNoSuperClass(ClassWrapper classWrapper) {
        if (classWrapper.superClass() != null) {
            throw new ConfigurationValidationException(classWrapper, "Must not have a superclass.");
        }
    }

    @SafeVarargs
    static void assertSuperclassHasAnnotations(ClassWrapper classWrapper, Class<? extends Annotation> ... annotations) {
        if (!ConfigurationProcessorUtils.containsAnyAnnotation(classWrapper.requiredSuperClass().clazz(), annotations)) {
            throw new ConfigurationValidationException(classWrapper, String.format("Superclass must be annotated with %s.", ConfigurationProcessorUtils.joinSimpleName(" or ", annotations)));
        }
    }

    static void assertNoFieldNameConflictsWithSuperClass(ClassWrapper classWrapper) {
        Collection<Name> duplicateFieldNames = Validator.findDuplicates(classWrapper.fields(), classWrapper.requiredSuperClass().fields());
        if (!duplicateFieldNames.isEmpty()) {
            throw new ConfigurationValidationException(classWrapper, String.format("Duplicate field names detected with the superclass %s: %s.", classWrapper.requiredSuperClass(), duplicateFieldNames));
        }
    }

    private static Collection<Name> findDuplicates(Collection<VariableElement> fields1, Collection<VariableElement> fields2) {
        if (fields1.isEmpty() || fields2.isEmpty()) {
            return List.of();
        }
        Set fieldNames1 = fields1.stream().map(VariableElement::getSimpleName).collect(Collectors.toSet());
        return fields2.stream().map(VariableElement::getSimpleName).filter(fieldNames1::contains).collect(Collectors.toList());
    }

    void assertFieldType(ClassWrapper classWrapper, VariableElement field, Class<?> expectedType) {
        if (!ConfigurationProcessorUtils.sameType(this.processingEnvironment, field.asType(), expectedType)) {
            throw new ConfigurationValidationException(classWrapper, String.format("Field '%s' must be a %s.", field.getSimpleName(), expectedType.getSimpleName()));
        }
    }

    void assertValidValueFieldType(ClassWrapper classWrapper, VariableElement field) {
        if (!ConfigurationProcessorUtils.isValidValueAnnotationFieldType(this.processingEnvironment, field.asType())) {
            throw new ConfigurationValidationException(classWrapper, String.format("Field '%s' must have one of the following types: boolean, int, long, double, String, UUID or an array of aforementioned types.", field.getSimpleName()));
        }
    }

    @SafeVarargs
    static void assertHasCompatibleTopLevelAnnotation(ClassWrapper classWrapper, Class<? extends Annotation> currentAnnotation, Class<? extends Annotation> ... compatibleAnnotations) {
        HashSet<Class<? extends Annotation>> allCompatibleAnnotations = new HashSet<Class<? extends Annotation>>();
        allCompatibleAnnotations.add(currentAnnotation);
        allCompatibleAnnotations.addAll(Arrays.asList(compatibleAnnotations));
        assert (ConfigurationProcessor.TOP_LEVEL_ANNOTATIONS.containsAll(allCompatibleAnnotations)) : allCompatibleAnnotations;
        Class[] conflictingAnnotations = (Class[])ConfigurationProcessor.TOP_LEVEL_ANNOTATIONS.stream().filter(annotation -> classWrapper.getAnnotation(annotation) != null && !allCompatibleAnnotations.contains(annotation)).toArray(Class[]::new);
        if (conflictingAnnotations.length > 0) {
            throw new ConfigurationValidationException(classWrapper, String.format("Has incompatible set of annotations: %s and %s.", ConfigurationProcessorUtils.simpleName(currentAnnotation), ConfigurationProcessorUtils.joinSimpleName(" and ", conflictingAnnotations)));
        }
    }
}

