/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class PolymorphicConfigValidator
extends Validator {
    public PolymorphicConfigValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        if (classWrapper.clazz().getAnnotation(PolymorphicConfig.class) == null) {
            return;
        }
        PolymorphicConfigValidator.assertHasCompatibleTopLevelAnnotation(classWrapper, PolymorphicConfig.class, new Class[0]);
        PolymorphicConfigValidator.assertHasNoSuperClass(classWrapper);
        List<VariableElement> annotatedFields = classWrapper.fieldsAnnotatedWith(PolymorphicId.class);
        if (annotatedFields.size() != 1 || classWrapper.fields().indexOf(annotatedFields.get(0)) != 0) {
            throw new ConfigurationValidationException(classWrapper, String.format("Must contain one field with %s and it must be the first in the schema.", ConfigurationProcessorUtils.simpleName(PolymorphicConfig.class), ConfigurationProcessorUtils.simpleName(PolymorphicId.class)));
        }
    }
}

