/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import javax.annotation.processing.ProcessingEnvironment;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class PolymorphicConfigInstanceValidator
extends Validator {
    public PolymorphicConfigInstanceValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        if (classWrapper.clazz().getAnnotation(PolymorphicConfigInstance.class) == null) {
            return;
        }
        PolymorphicConfigInstanceValidator.assertHasCompatibleTopLevelAnnotation(classWrapper, PolymorphicConfigInstance.class, new Class[0]);
        PolymorphicConfigInstanceValidator.assertNotContainsFieldAnnotatedWith(classWrapper, PolymorphicId.class);
        String id = classWrapper.getAnnotation(PolymorphicConfigInstance.class).value();
        if (id == null || id.isBlank()) {
            throw new ConfigurationValidationException(classWrapper, String.format("%s value cannot be empty.", ConfigurationProcessorUtils.simpleName(PolymorphicConfigInstance.class) + ".id()"));
        }
        PolymorphicConfigInstanceValidator.assertHasSuperClass(classWrapper);
        PolymorphicConfigInstanceValidator.assertSuperclassHasAnnotations(classWrapper, PolymorphicConfig.class);
        PolymorphicConfigInstanceValidator.assertNoFieldNameConflictsWithSuperClass(classWrapper);
    }
}

