/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class NamedConfigValueValidator
extends Validator {
    public NamedConfigValueValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        for (VariableElement field : classWrapper.fields()) {
            if (field.getAnnotation(NamedConfigValue.class) == null) continue;
            TypeElement fieldType = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(field.asType());
            if (ConfigurationProcessorUtils.containsAnyAnnotation(fieldType, Config.class, PolymorphicConfig.class)) continue;
            throw new ConfigurationValidationException(classWrapper, String.format("Class %s for field %s must be annotated with %s.", fieldType.getQualifiedName(), field.getSimpleName(), ConfigurationProcessorUtils.joinSimpleName(" or ", Config.class, PolymorphicConfig.class)));
        }
    }
}

