/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import java.util.UUID;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InjectedValue;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Secret;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class MiscellaneousIssuesValidator
extends Validator {
    public MiscellaneousIssuesValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        if (!classWrapper.clazz().getSimpleName().toString().endsWith("ConfigurationSchema")) {
            throw new ConfigurationValidationException(classWrapper, String.format("Class name must end with '%s'.", "ConfigurationSchema"));
        }
        for (VariableElement field : classWrapper.fields()) {
            if (!field.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new ConfigurationValidationException(classWrapper, String.format("Field %s must be public.", field.getSimpleName()));
            }
            boolean containsAnySupportedAnnotation = ConfigurationProcessorUtils.containsAnyAnnotation(field, Value.class, ConfigValue.class, NamedConfigValue.class, PolymorphicId.class, InjectedName.class, InternalId.class, InjectedValue.class, Secret.class);
            if (!containsAnySupportedAnnotation) {
                throw new ConfigurationValidationException(classWrapper, String.format("Field '%s' does not contain any supported annotations", field.getSimpleName()));
            }
            if (field.getAnnotation(Value.class) != null) {
                this.assertValidValueFieldType(classWrapper, field);
            }
            if (field.getAnnotation(PolymorphicId.class) != null) {
                this.assertFieldType(classWrapper, field, String.class);
            }
            if (field.getAnnotation(InternalId.class) != null) {
                this.assertFieldType(classWrapper, field, UUID.class);
            }
            if (field.getAnnotation(Secret.class) != null) {
                this.assertFieldType(classWrapper, field, String.class);
            }
            if (field.getAnnotation(Name.class) == null || field.getAnnotation(ConfigValue.class) != null) continue;
            throw new ConfigurationValidationException(classWrapper, String.format("Field '%s' annotated with %s can only be used together with %s.", field.getSimpleName(), ConfigurationProcessorUtils.simpleName(Name.class), ConfigurationProcessorUtils.simpleName(ConfigValue.class)));
        }
    }
}

