/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import org.apache.ignite.configuration.annotation.InjectedValue;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;
import org.apache.ignite.internal.util.CollectionUtils;

public class InjectedValueValidator
extends Validator {
    public InjectedValueValidator(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        List<VariableElement> injectedValueFields = classWrapper.fieldsAnnotatedWith(InjectedValue.class);
        if (injectedValueFields.isEmpty()) {
            return;
        }
        List<VariableElement> valueFields = classWrapper.fieldsAnnotatedWith(Value.class);
        if (injectedValueFields.size() > 1 || !valueFields.isEmpty()) {
            throw new ConfigurationValidationException(classWrapper, String.format("Field marked as %s must be the only \"value\" field in the schema, found: %s", ConfigurationProcessorUtils.simpleName(InjectedValue.class), CollectionUtils.concat((List[])new List[]{injectedValueFields, valueFields})));
        }
        VariableElement injectedValueField = injectedValueFields.get(0);
        this.assertValidValueFieldType(classWrapper, injectedValueField);
    }
}

