/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class ConfigValueValidator
extends Validator {
    public ConfigValueValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        for (VariableElement field : classWrapper.fields()) {
            if (field.getAnnotation(ConfigValue.class) == null) continue;
            TypeElement fieldType = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(field.asType());
            if (!ConfigurationProcessorUtils.containsAnyAnnotation(fieldType, Config.class, PolymorphicConfig.class)) {
                throw new ConfigurationValidationException(classWrapper, String.format("Class for %s field must be defined as %s", ConfigurationProcessorUtils.simpleName(ConfigValue.class), ConfigurationProcessorUtils.joinSimpleName(" or ", Config.class, PolymorphicConfig.class)));
            }
            if (field.getAnnotation(Name.class) != null) {
                return;
            }
            ClassWrapper fieldClass = new ClassWrapper(this.processingEnvironment, fieldType);
            if (!fieldClass.fieldsAnnotatedWith(InjectedName.class).isEmpty()) {
                throw new ConfigurationValidationException(classWrapper, String.format("Missing %s annotation for field '%s'.", ConfigurationProcessorUtils.simpleName(Name.class), field.getSimpleName()));
            }
            ClassWrapper fieldSuperClass = fieldClass.superClass();
            if (fieldSuperClass == null) {
                return;
            }
            if (fieldSuperClass.fieldsAnnotatedWith(InjectedName.class).isEmpty()) continue;
            throw new ConfigurationValidationException(classWrapper, String.format("Missing %s annotation for field in superclass: %s.%s.", ConfigurationProcessorUtils.simpleName(Name.class), field.getEnclosingElement(), field.getSimpleName()));
        }
    }
}

