/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor;

import com.squareup.javapoet.ClassName;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class ConfigurationProcessorUtils {
    public static ClassName getConfigurationInterfaceName(ClassName schemaClassName) {
        return ClassName.get((String)schemaClassName.packageName(), (String)schemaClassName.simpleName().replaceAll("Schema$", ""), (String[])new String[0]);
    }

    public static ClassName getViewName(ClassName schemaClassName) {
        return ClassName.get((String)schemaClassName.packageName(), (String)schemaClassName.simpleName().replace("ConfigurationSchema", "View"), (String[])new String[0]);
    }

    public static ClassName getChangeName(ClassName schemaClassName) {
        return ClassName.get((String)schemaClassName.packageName(), (String)schemaClassName.simpleName().replace("ConfigurationSchema", "Change"), (String[])new String[0]);
    }

    public static String simpleName(Class<? extends Annotation> annotationClass) {
        return "@" + annotationClass.getSimpleName();
    }

    @SafeVarargs
    public static String joinSimpleName(String delimiter, Class<? extends Annotation> ... annotations) {
        return Stream.of(annotations).map(ConfigurationProcessorUtils::simpleName).collect(Collectors.joining(delimiter));
    }

    @SafeVarargs
    public static boolean containsAnyAnnotation(List<? extends Element> elements, Class<? extends Annotation> ... annotations) {
        return elements.stream().anyMatch(e -> ConfigurationProcessorUtils.containsAnyAnnotation(e, annotations));
    }

    @SafeVarargs
    public static boolean containsAnyAnnotation(Element element, Class<? extends Annotation> ... annotations) {
        return Arrays.stream(annotations).anyMatch(a -> element.getAnnotation(a) != null);
    }

    public static boolean isValidValueAnnotationFieldType(ProcessingEnvironment processingEnvironment, TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            type = ((ArrayType)type).getComponentType();
        }
        if (type.getKind().isPrimitive()) {
            return true;
        }
        return ConfigurationProcessorUtils.sameType(processingEnvironment, type, String.class) || ConfigurationProcessorUtils.sameType(processingEnvironment, type, UUID.class);
    }

    public static boolean sameType(ProcessingEnvironment processingEnvironment, TypeMirror type1, Class<?> type2) {
        TypeMirror classType = processingEnvironment.getElementUtils().getTypeElement(type2.getCanonicalName()).asType();
        return processingEnvironment.getTypeUtils().isSameType(classType, type1);
    }
}

