/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InjectedValue;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class InjectedNameValidator
extends Validator {
    private static final List<Class<? extends Annotation>> INCOMPATIBLE_ANNOTATIONS = List.of(ConfigValue.class, Value.class, InjectedValue.class, PolymorphicId.class, InternalId.class);

    public InjectedNameValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        List<VariableElement> injectedNameFields = classWrapper.fieldsAnnotatedWith(InjectedName.class);
        if (injectedNameFields.isEmpty()) {
            return;
        }
        if (injectedNameFields.size() > 1) {
            throw new ConfigurationValidationException(classWrapper, String.format("Contains more than one field with %s: %s.", ConfigurationProcessorUtils.simpleName(InjectedName.class), injectedNameFields.stream().map(VariableElement::getSimpleName).collect(Collectors.toList())));
        }
        if (!ConfigurationProcessorUtils.containsAnyAnnotation(classWrapper.clazz(), Config.class, PolymorphicConfig.class, AbstractConfiguration.class)) {
            throw new ConfigurationValidationException(classWrapper, String.format("%s can only be present in a class annotated with %s.", ConfigurationProcessorUtils.simpleName(InjectedName.class), ConfigurationProcessorUtils.joinSimpleName(" or ", Config.class, PolymorphicConfig.class, AbstractConfiguration.class)));
        }
        VariableElement injectedNameField = injectedNameFields.get(0);
        this.assertFieldType(classWrapper, injectedNameField, String.class);
        Class[] incompatibleAnnotations = (Class[])INCOMPATIBLE_ANNOTATIONS.stream().filter(annotation -> injectedNameField.getAnnotation(annotation) != null).toArray(Class[]::new);
        if (incompatibleAnnotations.length > 0) {
            throw new ConfigurationValidationException(classWrapper, String.format("Field '%s' contains annotations conflicting with %s: %s.", injectedNameField.getSimpleName(), ConfigurationProcessorUtils.simpleName(InjectedName.class), ConfigurationProcessorUtils.joinSimpleName(" and ", incompatibleAnnotations)));
        }
    }
}

