/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor.validation;

import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigurationExtension;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.ConfigurationValidationException;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

public class ConfigValidator
extends Validator {
    public ConfigValidator(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment);
    }

    @Override
    public void validate(ClassWrapper classWrapper) {
        if (classWrapper.getAnnotation(Config.class) == null) {
            return;
        }
        ConfigValidator.assertHasCompatibleTopLevelAnnotation(classWrapper, Config.class, ConfigurationExtension.class);
        ConfigValidator.assertNotContainsFieldAnnotatedWith(classWrapper, PolymorphicId.class);
        ClassWrapper superClass = classWrapper.superClass();
        if (superClass == null) {
            return;
        }
        ConfigValidator.assertSuperclassHasAnnotations(classWrapper, AbstractConfiguration.class);
        ConfigValidator.assertNoFieldNameConflictsWithSuperClass(classWrapper);
        ConfigValidator.checkDuplicateAnnotationsWithSuperClass(classWrapper, InjectedName.class);
        ConfigValidator.checkDuplicateAnnotationsWithSuperClass(classWrapper, InternalId.class);
    }

    private static void checkDuplicateAnnotationsWithSuperClass(ClassWrapper classWrapper, Class<? extends Annotation> annotationClass) {
        if (ConfigurationProcessorUtils.containsAnyAnnotation(classWrapper.fields(), annotationClass) && ConfigurationProcessorUtils.containsAnyAnnotation(classWrapper.requiredSuperClass().fields(), annotationClass)) {
            throw new ConfigurationValidationException(classWrapper, String.format("Field with %s is already present in the superclass %s.", ConfigurationProcessorUtils.simpleName(annotationClass), classWrapper.requiredSuperClass()));
        }
    }
}

