/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.PolymorphicChange;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigValue;
import org.apache.ignite.configuration.annotation.ConfigurationExtension;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.configuration.annotation.InjectedName;
import org.apache.ignite.configuration.annotation.InjectedValue;
import org.apache.ignite.configuration.annotation.InternalId;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicConfigInstance;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.configuration.annotation.Value;
import org.apache.ignite.internal.configuration.processor.ClassWrapper;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorException;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.configuration.processor.validation.AbstractConfigurationValidator;
import org.apache.ignite.internal.configuration.processor.validation.ConfigValidator;
import org.apache.ignite.internal.configuration.processor.validation.ConfigValueValidator;
import org.apache.ignite.internal.configuration.processor.validation.ConfigurationExtentionValidator;
import org.apache.ignite.internal.configuration.processor.validation.ConfigurationRootValidator;
import org.apache.ignite.internal.configuration.processor.validation.InjectedNameValidator;
import org.apache.ignite.internal.configuration.processor.validation.InjectedValueValidator;
import org.apache.ignite.internal.configuration.processor.validation.MiscellaneousIssuesValidator;
import org.apache.ignite.internal.configuration.processor.validation.NamedConfigValueValidator;
import org.apache.ignite.internal.configuration.processor.validation.PolymorphicConfigInstanceValidator;
import org.apache.ignite.internal.configuration.processor.validation.PolymorphicConfigValidator;
import org.apache.ignite.internal.configuration.processor.validation.Validator;

@AutoService(value={Processor.class})
public class ConfigurationProcessor
extends AbstractProcessor {
    public static final Set<Class<? extends Annotation>> TOP_LEVEL_ANNOTATIONS = Set.of(Config.class, ConfigurationRoot.class, ConfigurationExtension.class, PolymorphicConfig.class, PolymorphicConfigInstance.class, AbstractConfiguration.class);
    private static final String INDENT = "    ";
    private static final ClassName ROOT_KEY_CLASSNAME = ClassName.get((String)"org.apache.ignite.configuration", (String)"RootKey", (String[])new String[0]);
    private static final ClassName POLYMORPHIC_CHANGE_CLASSNAME = ClassName.get(PolymorphicChange.class);
    public static final String CONFIGURATION_SCHEMA_POSTFIX = "ConfigurationSchema";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        try {
            return this.process0(roundEnvironment);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to process configuration: " + sw);
            return false;
        }
    }

    private List<Validator> validators() {
        return List.of(new MiscellaneousIssuesValidator(this.processingEnv), new ConfigurationExtentionValidator(this.processingEnv), new PolymorphicConfigValidator(this.processingEnv), new PolymorphicConfigInstanceValidator(this.processingEnv), new AbstractConfigurationValidator(this.processingEnv), new ConfigurationRootValidator(this.processingEnv), new ConfigValidator(this.processingEnv), new InjectedNameValidator(this.processingEnv), new InjectedValueValidator(this.processingEnv), new ConfigValueValidator(this.processingEnv), new NamedConfigValueValidator(this.processingEnv));
    }

    private boolean process0(RoundEnvironment roundEnvironment) {
        List annotatedConfigs = roundEnvironment.getElementsAnnotatedWithAny(TOP_LEVEL_ANNOTATIONS).stream().filter(element -> element.getKind() == ElementKind.CLASS).map(TypeElement.class::cast).collect(Collectors.toList());
        if (annotatedConfigs.isEmpty()) {
            return false;
        }
        List<Validator> validators = this.validators();
        for (TypeElement clazz : annotatedConfigs) {
            ClassWrapper superClass;
            ClassWrapper classWrapper = new ClassWrapper(this.processingEnv, clazz);
            validators.forEach(validator -> validator.validate(classWrapper));
            Elements elementUtils = this.processingEnv.getElementUtils();
            String packageName = elementUtils.getPackageOf(clazz).getQualifiedName().toString();
            ClassName schemaClassName = ClassName.get((String)packageName, (String)clazz.getSimpleName().toString(), (String[])new String[0]);
            ClassName configInterface = ConfigurationProcessorUtils.getConfigurationInterfaceName(schemaClassName);
            TypeSpec.Builder configurationInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)configInterface).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("@see $T", new Object[]{schemaClassName});
            for (VariableElement field : classWrapper.fields()) {
                ConfigurationProcessor.createGetters(configurationInterfaceBuilder, field);
            }
            boolean isRootConfig = clazz.getAnnotation(ConfigurationRoot.class) != null;
            boolean isExtendingConfig = clazz.getAnnotation(ConfigurationExtension.class) != null;
            boolean isPolymorphicConfig = clazz.getAnnotation(PolymorphicConfig.class) != null;
            boolean isPolymorphicInstance = clazz.getAnnotation(PolymorphicConfigInstance.class) != null;
            this.createPojoBindings(classWrapper, schemaClassName, configurationInterfaceBuilder, isExtendingConfig && !isRootConfig || isPolymorphicInstance, isPolymorphicConfig, isPolymorphicInstance);
            if (isRootConfig) {
                ConfigurationProcessor.createRootKeyField(configInterface, configurationInterfaceBuilder, schemaClassName, clazz);
            } else if (isExtendingConfig && (superClass = classWrapper.requiredSuperClass()).getAnnotation(ConfigurationRoot.class) != null) {
                ClassName superClassSchemaClassName = ClassName.get((TypeElement)superClass.clazz());
                ConfigurationProcessor.createExtensionKeyField(configInterface, configurationInterfaceBuilder, schemaClassName, superClassSchemaClassName);
            }
            configurationInterfaceBuilder.addMethod(MethodSpec.methodBuilder((String)"directProxy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(Override.class).returns((TypeName)configInterface).build());
            this.buildClass(packageName, configurationInterfaceBuilder.build());
        }
        return true;
    }

    private static void createRootKeyField(ClassName configInterface, TypeSpec.Builder configurationClassBuilder, ClassName schemaClassName, TypeElement realSchemaClass) {
        ClassName viewClassName = ConfigurationProcessorUtils.getViewName(schemaClassName);
        ClassName changeClassName = ConfigurationProcessorUtils.getChangeName(schemaClassName);
        ConfigurationRoot rootAnnotation = realSchemaClass.getAnnotation(ConfigurationRoot.class);
        ConfigurationExtension extensionAnnotation = realSchemaClass.getAnnotation(ConfigurationExtension.class);
        ParameterizedTypeName fieldTypeName = ParameterizedTypeName.get((ClassName)ROOT_KEY_CLASSNAME, (TypeName[])new TypeName[]{configInterface, viewClassName, changeClassName});
        FieldSpec keyField = FieldSpec.builder((TypeName)fieldTypeName, (String)"KEY", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("new $T($S, $T.$L, $T.class, $L)", new Object[]{ROOT_KEY_CLASSNAME, rootAnnotation.rootName(), ConfigurationType.class, rootAnnotation.type(), realSchemaClass, extensionAnnotation != null && extensionAnnotation.internal()}).build();
        configurationClassBuilder.addField(keyField);
    }

    private static void createExtensionKeyField(ClassName configInterface, TypeSpec.Builder configurationClassBuilder, ClassName schemaClassName, ClassName superClassSchemaClassName) {
        ClassName viewClassName = ConfigurationProcessorUtils.getViewName(schemaClassName);
        ClassName changeClassName = ConfigurationProcessorUtils.getChangeName(schemaClassName);
        ClassName superConfigInterface = ConfigurationProcessorUtils.getConfigurationInterfaceName(superClassSchemaClassName);
        ParameterizedTypeName fieldTypeName = ParameterizedTypeName.get((ClassName)ROOT_KEY_CLASSNAME, (TypeName[])new TypeName[]{configInterface, viewClassName, changeClassName});
        FieldSpec keyField = FieldSpec.builder((TypeName)fieldTypeName, (String)"KEY", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("($T) $T.KEY", new Object[]{ROOT_KEY_CLASSNAME, superConfigInterface}).build();
        configurationClassBuilder.addField(keyField);
    }

    private static void createGetters(TypeSpec.Builder configurationInterfaceBuilder, VariableElement field) {
        String fieldName = field.getSimpleName().toString();
        TypeName interfaceGetMethodType = ConfigurationProcessor.getInterfaceGetMethodType(field);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(interfaceGetMethodType).addJavadoc("@see $T#" + field, new Object[]{field.getEnclosingElement()});
        if (field.getAnnotation(Deprecated.class) != null) {
            builder.addAnnotation(Deprecated.class);
        }
        MethodSpec interfaceGetMethod = builder.build();
        configurationInterfaceBuilder.addMethod(interfaceGetMethod);
    }

    private static TypeName getInterfaceGetMethodType(VariableElement field) {
        TypeName baseType = TypeName.get((TypeMirror)field.asType());
        ConfigValue confAnnotation = field.getAnnotation(ConfigValue.class);
        if (confAnnotation != null) {
            return ConfigurationProcessorUtils.getConfigurationInterfaceName((ClassName)baseType);
        }
        NamedConfigValue namedConfigAnnotation = field.getAnnotation(NamedConfigValue.class);
        if (namedConfigAnnotation != null) {
            ClassName interfaceGetType = ConfigurationProcessorUtils.getConfigurationInterfaceName((ClassName)baseType);
            ClassName viewClassType = ConfigurationProcessorUtils.getViewName((ClassName)baseType);
            ClassName changeClassType = ConfigurationProcessorUtils.getChangeName((ClassName)baseType);
            return ParameterizedTypeName.get((ClassName)ClassName.get(NamedConfigurationTree.class), (TypeName[])new TypeName[]{interfaceGetType, viewClassType, changeClassType});
        }
        ClassName confValueClass = ClassName.get((String)"org.apache.ignite.configuration", (String)"ConfigurationValue", (String[])new String[0]);
        TypeName genericType = baseType;
        if (genericType.isPrimitive()) {
            genericType = genericType.box();
        }
        return ParameterizedTypeName.get((ClassName)confValueClass, (TypeName[])new TypeName[]{genericType});
    }

    private void createPojoBindings(ClassWrapper classWrapper, ClassName schemaClassName, TypeSpec.Builder configurationInterfaceBuilder, boolean extendBaseSchema, boolean isPolymorphicConfig, boolean isPolymorphicInstanceConfig) {
        Object configInterfaceType;
        ClassName changeBaseSchemaInterfaceType;
        ClassName viewBaseSchemaInterfaceType;
        boolean isSuperClassAbstractConfiguration;
        ClassName viewClsName = ConfigurationProcessorUtils.getViewName(schemaClassName);
        ClassName changeClsName = ConfigurationProcessorUtils.getChangeName(schemaClassName);
        ClassWrapper superClass = classWrapper.superClass();
        boolean bl = isSuperClassAbstractConfiguration = superClass != null && superClass.getAnnotation(AbstractConfiguration.class) != null;
        if (superClass != null && (extendBaseSchema || isSuperClassAbstractConfiguration)) {
            ClassName superClassSchemaClassName = ClassName.get((TypeElement)superClass.clazz());
            viewBaseSchemaInterfaceType = ConfigurationProcessorUtils.getViewName(superClassSchemaClassName);
            changeBaseSchemaInterfaceType = ConfigurationProcessorUtils.getChangeName(superClassSchemaClassName);
            configInterfaceType = isSuperClassAbstractConfiguration ? ParameterizedTypeName.get((ClassName)ConfigurationProcessorUtils.getConfigurationInterfaceName(superClassSchemaClassName), (TypeName[])new TypeName[]{viewClsName, changeClsName}) : ConfigurationProcessorUtils.getConfigurationInterfaceName(superClassSchemaClassName);
        } else {
            ClassName confTreeInterface = ClassName.get((String)"org.apache.ignite.configuration", (String)"ConfigurationTree", (String[])new String[0]);
            if (classWrapper.getAnnotation(AbstractConfiguration.class) != null) {
                configurationInterfaceBuilder.addTypeVariables(List.of(TypeVariableName.get((String)"VIEWT", (TypeName[])new TypeName[]{viewClsName}), TypeVariableName.get((String)"CHANGET", (TypeName[])new TypeName[]{changeClsName})));
                configInterfaceType = ParameterizedTypeName.get((ClassName)confTreeInterface, (TypeName[])new TypeName[]{TypeVariableName.get((String)"VIEWT"), TypeVariableName.get((String)"CHANGET")});
            } else {
                configInterfaceType = ParameterizedTypeName.get((ClassName)confTreeInterface, (TypeName[])new TypeName[]{viewClsName, changeClsName});
            }
            viewBaseSchemaInterfaceType = null;
            changeBaseSchemaInterfaceType = null;
        }
        configurationInterfaceBuilder.addSuperinterface((TypeName)configInterfaceType);
        TypeSpec.Builder viewClsBuilder = TypeSpec.interfaceBuilder((ClassName)viewClsName).addJavadoc("@see $T", new Object[]{schemaClassName}).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (viewBaseSchemaInterfaceType != null) {
            viewClsBuilder.addSuperinterface((TypeName)viewBaseSchemaInterfaceType);
        }
        TypeSpec.Builder changeClsBuilder = TypeSpec.interfaceBuilder((ClassName)changeClsName).addSuperinterface((TypeName)viewClsName).addJavadoc("@see $T", new Object[]{schemaClassName}).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (changeBaseSchemaInterfaceType != null) {
            changeClsBuilder.addSuperinterface((TypeName)changeBaseSchemaInterfaceType);
        }
        if (isPolymorphicInstanceConfig) {
            changeClsBuilder.addSuperinterface((TypeName)POLYMORPHIC_CHANGE_CLASSNAME);
        }
        ClassName consumerClsName = ClassName.get(Consumer.class);
        for (VariableElement field : classWrapper.fields()) {
            boolean isDeprecated;
            TypeName changeFieldType;
            String fieldName = field.getSimpleName().toString();
            TypeMirror schemaFieldType = field.asType();
            TypeName schemaFieldTypeName = TypeName.get((TypeMirror)schemaFieldType);
            boolean leafField = ConfigurationProcessorUtils.isValidValueAnnotationFieldType(this.processingEnv, schemaFieldType) || !((ClassName)schemaFieldTypeName).simpleName().contains(CONFIGURATION_SCHEMA_POSTFIX);
            TypeName viewFieldType = leafField ? schemaFieldTypeName : ConfigurationProcessorUtils.getViewName((ClassName)schemaFieldTypeName);
            Object object = changeFieldType = leafField ? schemaFieldTypeName : ConfigurationProcessorUtils.getChangeName((ClassName)schemaFieldTypeName);
            if (field.getAnnotation(NamedConfigValue.class) != null) {
                changeFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(NamedListChange.class), (TypeName[])new TypeName[]{viewFieldType, changeFieldType});
                viewFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(NamedListView.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)viewFieldType)});
            }
            MethodSpec.Builder getMtdBuilder = MethodSpec.methodBuilder((String)fieldName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addJavadoc("@see $T#" + field, new Object[]{field.getEnclosingElement()}).returns(viewFieldType);
            boolean bl2 = isDeprecated = field.getAnnotation(Deprecated.class) != null;
            if (isDeprecated) {
                getMtdBuilder.addAnnotation(Deprecated.class);
            }
            viewClsBuilder.addMethod(getMtdBuilder.build());
            if (ConfigurationProcessorUtils.containsAnyAnnotation(field, PolymorphicId.class, InjectedName.class, InternalId.class)) continue;
            String changeMtdName = "change" + ConfigurationProcessor.capitalize(fieldName);
            MethodSpec.Builder changeMtdBuilder = MethodSpec.methodBuilder((String)changeMtdName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addJavadoc("@see $T#" + field, new Object[]{field.getEnclosingElement()}).returns((TypeName)changeClsName);
            if (isDeprecated) {
                changeMtdBuilder.addAnnotation(Deprecated.class);
            }
            if (ConfigurationProcessorUtils.containsAnyAnnotation(field, Value.class, InjectedValue.class)) {
                if (schemaFieldType.getKind() == TypeKind.ARRAY) {
                    changeMtdBuilder.varargs(true);
                }
                changeMtdBuilder.addParameter(changeFieldType, fieldName, new Modifier[0]);
            } else {
                changeMtdBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)consumerClsName, (TypeName[])new TypeName[]{changeFieldType}), fieldName, new Modifier[0]);
                MethodSpec.Builder shortChangeMtdBuilder = MethodSpec.methodBuilder((String)changeMtdName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addJavadoc("@see $T#" + field, new Object[]{field.getEnclosingElement()}).returns(changeFieldType);
                if (isDeprecated) {
                    shortChangeMtdBuilder.addAnnotation(Deprecated.class);
                }
                changeClsBuilder.addMethod(shortChangeMtdBuilder.build());
            }
            changeClsBuilder.addMethod(changeMtdBuilder.build());
        }
        if (isPolymorphicConfig) {
            ParameterizedTypeName parameterType = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
            TypeVariableName typeVariable = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{changeClsName, POLYMORPHIC_CHANGE_CLASSNAME});
            MethodSpec.Builder convertByChangeClassMtdBuilder = MethodSpec.methodBuilder((String)"convert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addTypeVariable(typeVariable).addParameter((TypeName)parameterType, "changeClass", new Modifier[0]).returns((TypeName)TypeVariableName.get((String)"T"));
            changeClsBuilder.addMethod(convertByChangeClassMtdBuilder.build());
            MethodSpec.Builder convertByStringMtdBuilder = MethodSpec.methodBuilder((String)"convert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ClassName.get(String.class), "polymorphicTypeId", new Modifier[0]).returns((TypeName)changeClsName);
            changeClsBuilder.addMethod(convertByStringMtdBuilder.build());
        }
        TypeSpec viewCls = viewClsBuilder.build();
        TypeSpec changeCls = changeClsBuilder.build();
        this.buildClass(viewClsName.packageName(), viewCls);
        this.buildClass(changeClsName.packageName(), changeCls);
    }

    private void buildClass(String packageName, TypeSpec cls) {
        try {
            JavaFile.builder((String)packageName, (TypeSpec)cls).indent(INDENT).build().writeTo(this.processingEnv.getFiler());
        }
        catch (Throwable throwable) {
            throw new ConfigurationProcessorException("Failed to generate class " + packageName + "." + cls.name, throwable);
        }
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return TOP_LEVEL_ANNOTATIONS.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

