/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.processor;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.apache.ignite.internal.configuration.processor.ConfigurationProcessorUtils;
import org.apache.ignite.internal.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class ClassWrapper {
    private final ProcessingEnvironment processingEnvironment;
    private final TypeElement clazz;
    private final List<VariableElement> fields;
    private final Lazy<ClassWrapper> superClass = new Lazy(this::computeSuperClass);

    public ClassWrapper(ProcessingEnvironment processingEnvironment, TypeElement clazz) {
        this.processingEnvironment = processingEnvironment;
        this.clazz = clazz;
        this.fields = ClassWrapper.fields(clazz);
    }

    public TypeElement clazz() {
        return this.clazz;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.clazz.getAnnotation(annotationType);
    }

    @Nullable
    public ClassWrapper superClass() {
        return (ClassWrapper)this.superClass.get();
    }

    public ClassWrapper requiredSuperClass() {
        ClassWrapper superClass = this.superClass();
        if (superClass == null) {
            throw new NullPointerException(String.format("Class %s does not have a superclass", this));
        }
        return superClass;
    }

    @Nullable
    private ClassWrapper computeSuperClass() {
        TypeMirror superClassType = this.clazz.getSuperclass();
        if (ConfigurationProcessorUtils.sameType(this.processingEnvironment, superClassType, Object.class)) {
            return null;
        }
        TypeElement superType = (TypeElement)this.processingEnvironment.getTypeUtils().asElement(superClassType);
        return new ClassWrapper(this.processingEnvironment, superType);
    }

    private static List<VariableElement> fields(TypeElement type) {
        return type.getEnclosedElements().stream().filter(el -> el.getKind() == ElementKind.FIELD).filter(el -> !el.getModifiers().contains((Object)Modifier.STATIC)).map(VariableElement.class::cast).collect(Collectors.toList());
    }

    public List<VariableElement> fields() {
        return this.fields;
    }

    public List<VariableElement> fieldsAnnotatedWith(Class<? extends Annotation> annotationClass) {
        return this.fields.stream().filter(f -> f.getAnnotation(annotationClass) != null).collect(Collectors.toList());
    }

    public String toString() {
        return this.clazz.getQualifiedName().toString();
    }
}

