/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import java.util.List;
import org.apache.ignite.internal.compute.ComputeMessagesFactory;
import org.apache.ignite.internal.compute.ComputeMessagesTypeInfos;
import org.apache.ignite.internal.compute.message.DeploymentUnitMsg;
import org.apache.ignite.internal.compute.message.ExecuteRequest;
import org.apache.ignite.internal.compute.message.ExecuteRequestBuilder;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.gridgain.internal.security.context.message.UserContext;

class ExecuteRequestDeserializer
implements MessageDeserializer<ExecuteRequest> {
    private final ExecuteRequestBuilder msg;

    ExecuteRequestDeserializer(ComputeMessagesFactory messageFactory) {
        this.msg = messageFactory.executeRequest();
    }

    public Class<ExecuteRequest> klass() {
        return ExecuteRequest.class;
    }

    public ExecuteRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ComputeMessagesTypeInfos.executeRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readList("deploymentUnits", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.deploymentUnits((List<DeploymentUnitMsg>)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readByteArray("executeOptionsByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.executeOptionsByteArray((byte[])tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readByteArray("inputByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.inputByteArray((byte[])tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("jobClassName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.jobClassName((String)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = (UserContext)reader.readMessage("userContext");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.userContext((UserContext)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ExecuteRequest.class);
    }
}

