/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.executor;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.cache.manager.IgniteCaches;
import org.apache.ignite.internal.compute.executor.SecuredTableViewInternal;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.rbac.privileges.Selector;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class SecuredIgniteTables
implements IgniteTables,
IgniteCaches {
    private static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private static final Privilege READ_SCHEMA_PRIVILEGE = Privilege.builder().action(Action.READ_SCHEMA).selector(Selector.schema((String)"PUBLIC")).build();
    private final IgniteTables tables;
    private final IgniteCaches caches;
    private final Authorizer authorizer;
    private final SecurityContext securityContext;

    SecuredIgniteTables(IgniteTables tables, IgniteCaches caches, Authorizer authorizer, SecurityContext securityContext) {
        this.tables = tables;
        this.caches = caches;
        this.authorizer = authorizer;
        this.securityContext = securityContext;
    }

    public List<Table> tables() {
        return SecuredIgniteTables.join(this.tablesAsync());
    }

    public List<Cache> caches() {
        return SecuredIgniteTables.join(this.cachesAsync());
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> ((IgniteTables)this.tables).tablesAsync()).thenApply(tables -> tables.stream().map(this::wrapTable).collect(Collectors.toList()));
    }

    public CompletableFuture<List<Cache>> cachesAsync() {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> ((IgniteCaches)this.caches).cachesAsync()).thenApply(tables -> tables.stream().map(this::wrapCache).collect(Collectors.toList()));
    }

    public Table table(String name) {
        return SecuredIgniteTables.join(this.tableAsync(name));
    }

    public Table table(QualifiedName name) {
        return SecuredIgniteTables.join(this.tableAsync(name));
    }

    public Cache cache(String name) {
        return SecuredIgniteTables.join(this.cacheAsync(name));
    }

    @Nullable
    public Cache cache(QualifiedName name) {
        return SecuredIgniteTables.join(this.cacheAsync(name));
    }

    public CompletableFuture<Table> tableAsync(String name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.tables.tableAsync(name)).thenApply(this::wrapTable);
    }

    public CompletableFuture<Table> tableAsync(QualifiedName name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.tables.tableAsync(name)).thenApply(this::wrapTable);
    }

    public CompletableFuture<Cache> cacheAsync(String name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.caches.cacheAsync(name)).thenApply(this::wrapCache);
    }

    public CompletableFuture<Cache> cacheAsync(QualifiedName name) {
        return this.authorizer.authorizeThenCompose(READ_SCHEMA_PRIVILEGE, () -> this.caches.cacheAsync(name)).thenApply(this::wrapCache);
    }

    @Nullable
    private SecuredTableViewInternal wrapTable(@Nullable Table table) {
        if (table == null) {
            return null;
        }
        return new SecuredTableViewInternal((TableViewInternal)Wrappers.unwrap((Object)table, TableViewInternal.class), this.authorizer, this.securityContext);
    }

    @Nullable
    private SecuredTableViewInternal wrapCache(@Nullable Cache cache) {
        if (cache == null) {
            return null;
        }
        return new SecuredTableViewInternal((TableViewInternal)Wrappers.unwrap((Object)cache, TableViewInternal.class), this.authorizer, this.securityContext);
    }

    private static <T> T join(CompletableFuture<T> future) {
        try {
            return future.join();
        }
        catch (CompletionException ex) {
            throw SecuredIgniteTables.convertThrowable(ex.getCause());
        }
    }

    private static RuntimeException convertThrowable(Throwable th) {
        if (th instanceof RuntimeException) {
            return (RuntimeException)th;
        }
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, th);
    }
}

