/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.state;

import java.util.UUID;
import org.apache.ignite.compute.JobStatus;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.lang.ErrorGroups;

public class IllegalJobStatusTransition
extends IgniteInternalException {
    public IllegalJobStatusTransition(UUID jobId) {
        super(ErrorGroups.Compute.COMPUTE_JOB_STATUS_TRANSITION_ERR, "Failed to transition job status for nonexistent job " + jobId + ".");
    }

    public IllegalJobStatusTransition(UUID jobId, JobStatus prevStatus, JobStatus newStatus) {
        super(ErrorGroups.Compute.COMPUTE_JOB_STATUS_TRANSITION_ERR, IllegalJobStatusTransition.message(jobId, prevStatus, newStatus));
    }

    private static String message(UUID jobId, JobStatus prevStatus, JobStatus newStatus) {
        return "Failed to transition job " + jobId + " from status " + prevStatus + " to status " + newStatus;
    }
}

