/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import org.apache.ignite.internal.compute.ComputeMessagesFactory;
import org.apache.ignite.internal.compute.ComputeMessagesTypeInfos;
import org.apache.ignite.internal.compute.message.JobStateResponse;
import org.apache.ignite.internal.compute.message.JobStateResponseBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class JobStateResponseDeserializer
implements MessageDeserializer<JobStateResponse> {
    private final JobStateResponseBuilder msg;

    JobStateResponseDeserializer(ComputeMessagesFactory messageFactory) {
        this.msg = messageFactory.jobStateResponse();
    }

    public Class<JobStateResponse> klass() {
        return JobStateResponse.class;
    }

    public JobStateResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ComputeMessagesTypeInfos.jobStateResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("stateByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.stateByteArray(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                byte[] tmp = reader.readByteArray("throwableByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.throwableByteArray(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(JobStateResponse.class);
    }
}

