/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.compute.message.JobOwnerResponse;
import org.apache.ignite.internal.compute.message.JobOwnerResponseBuilder;
import org.apache.ignite.internal.compute.message.JobOwnerResponseSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JobOwnerResponseImpl
implements JobOwnerResponse,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 14;
    @IgniteToStringInclude
    private final String owner;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private JobOwnerResponseImpl(String owner, Throwable throwable, byte[] throwableByteArray) {
        this.owner = owner;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    @Override
    public String owner() {
        return this.owner;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return JobOwnerResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobOwnerResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 14;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobOwnerResponseImpl otherMessage = (JobOwnerResponseImpl)other;
        return Objects.equals(this.owner, otherMessage.owner) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.owner, this.throwable);
        return result;
    }

    public JobOwnerResponseImpl clone() {
        try {
            return (JobOwnerResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobOwnerResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements JobOwnerResponseBuilder {
        private String owner;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public JobOwnerResponseBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public JobOwnerResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public JobOwnerResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public String owner() {
            return this.owner;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public JobOwnerResponse build() {
            return new JobOwnerResponseImpl(this.owner, this.throwable, this.throwableByteArray);
        }

        @Override
        public JobOwnerResponse buildDeserialized() {
            return new JobOwnerResponseImpl(this.owner, this.throwable, this.throwableByteArray);
        }
    }
}

