/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.compute.message.JobChangePriorityRequest;
import org.apache.ignite.internal.compute.message.JobChangePriorityRequestBuilder;
import org.apache.ignite.internal.compute.message.JobChangePriorityRequestSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JobChangePriorityRequestImpl
implements JobChangePriorityRequest,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 9;
    @IgniteToStringInclude
    private final UUID jobId;
    @IgniteToStringInclude
    private final int priority;

    private JobChangePriorityRequestImpl(UUID jobId, int priority) {
        this.jobId = jobId;
        this.priority = priority;
    }

    @Override
    public UUID jobId() {
        return this.jobId;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public MessageSerializer serializer() {
        return JobChangePriorityRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobChangePriorityRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 9;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobChangePriorityRequestImpl otherMessage = (JobChangePriorityRequestImpl)other;
        return Objects.equals(this.jobId, otherMessage.jobId) && this.priority == otherMessage.priority;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.priority, this.jobId);
        return result;
    }

    public JobChangePriorityRequestImpl clone() {
        try {
            return (JobChangePriorityRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobChangePriorityRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements JobChangePriorityRequestBuilder {
        private UUID jobId;
        private int priority;

        private Builder() {
        }

        @Override
        public JobChangePriorityRequestBuilder jobId(UUID jobId) {
            Objects.requireNonNull(jobId, "jobId is not marked @Nullable");
            this.jobId = jobId;
            return this;
        }

        @Override
        public JobChangePriorityRequestBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public UUID jobId() {
            return this.jobId;
        }

        @Override
        public int priority() {
            return this.priority;
        }

        @Override
        public JobChangePriorityRequest build() {
            return new JobChangePriorityRequestImpl(Objects.requireNonNull(this.jobId, "jobId is not marked @Nullable"), this.priority);
        }

        @Override
        public JobChangePriorityRequest buildDeserialized() {
            return new JobChangePriorityRequestImpl(this.jobId, this.priority);
        }
    }
}

