/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import java.util.UUID;
import org.apache.ignite.internal.compute.ComputeMessagesFactory;
import org.apache.ignite.internal.compute.ComputeMessagesTypeInfos;
import org.apache.ignite.internal.compute.message.ExecuteResponse;
import org.apache.ignite.internal.compute.message.ExecuteResponseBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class ExecuteResponseDeserializer
implements MessageDeserializer<ExecuteResponse> {
    private final ExecuteResponseBuilder msg;

    ExecuteResponseDeserializer(ComputeMessagesFactory messageFactory) {
        this.msg = messageFactory.executeResponse();
    }

    public Class<ExecuteResponse> klass() {
        return ExecuteResponse.class;
    }

    public ExecuteResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(ComputeMessagesTypeInfos.executeResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readUuid("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.jobId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readByteArray("throwableByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.throwableByteArray((byte[])tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ExecuteResponse.class);
    }
}

