/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.configuration;

import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.compute.configuration.WasmConfigurationUtils;
import org.apache.ignite.internal.compute.configuration.WasmModuleMaxMemory;
import org.apache.ignite.internal.util.StringUtils;

public class WasmModuleMaxMemoryValidator
implements Validator<WasmModuleMaxMemory, String> {
    public void validate(WasmModuleMaxMemory annotation, ValidationContext<String> ctx) {
        String newValue = (String)ctx.getNewValue();
        if (StringUtils.nullOrBlank((String)newValue)) {
            return;
        }
        try {
            long maxMemBytes = WasmConfigurationUtils.parseMemorySize(newValue);
            WasmConfigurationUtils.memorySizeToPagesValidated(maxMemBytes);
        }
        catch (IllegalArgumentException e) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), e.getMessage()));
        }
    }
}

