/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskState;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.compute.ComputeUtils;
import org.apache.ignite.internal.compute.HybridTimestampProvider;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.marshalling.Marshaller;
import org.jetbrains.annotations.Nullable;

class TaskExecutionFutureWrapper<R>
implements TaskExecution<R>,
MarshallerProvider<R>,
HybridTimestampProvider {
    private final CompletableFuture<TaskExecution<R>> delegate;

    TaskExecutionFutureWrapper(CompletableFuture<TaskExecution<R>> delegate) {
        this.delegate = delegate;
    }

    public CompletableFuture<R> resultAsync() {
        return ComputeUtils.convertToComputeFuture(this.delegate.thenCompose(TaskExecution::resultAsync));
    }

    public CompletableFuture<@Nullable TaskState> stateAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.thenCompose(TaskExecution::stateAsync));
    }

    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.thenCompose(jobExecution -> jobExecution.changePriorityAsync(newPriority)));
    }

    public CompletableFuture<List<@Nullable JobState>> statesAsync() {
        return IgniteExceptionMapperUtil.convertToPublicFuture((CompletableFuture)this.delegate.thenCompose(TaskExecution::statesAsync));
    }

    @Override
    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        assert (this.delegate.isDone()) : "The future must be completed by the time you call `resultMarshaller`";
        return ((MarshallerProvider)this.delegate.join()).resultMarshaller();
    }

    @Override
    public boolean marshalResult() {
        assert (this.delegate.isDone()) : "The future must be completed by the time you call `marshalResult`";
        return ((MarshallerProvider)this.delegate.join()).marshalResult();
    }

    @Override
    public long hybridTimestamp() {
        assert (this.delegate.isDone()) : "The future must be completed by the time you call `hybridTimestamp`";
        return ((HybridTimestampProvider)this.delegate.join()).hybridTimestamp();
    }
}

