/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite.compute.BroadcastExecution;
import org.apache.ignite.compute.BroadcastJobTarget;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobExecutionOptions;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.compute.TaskDescriptor;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ExecutionContext;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite.internal.compute.task.FailedTaskExecution;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.table.TableViewInternal;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.table.Tuple;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public class LicensedIgniteCompute
implements IgniteComputeInternal,
Wrapper {
    private final IgniteComputeInternal compute;
    private final LicenseFeatureChecker licenseChecker;

    public LicensedIgniteCompute(IgniteComputeInternal compute, LicenseFeatureChecker licenseChecker) {
        this.compute = compute;
        this.licenseChecker = licenseChecker;
    }

    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitAsync(target, descriptor, arg, cancellationToken));
    }

    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitAsync(target, descriptor, arg, cancellationToken));
    }

    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        return (R)this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        return this.compute.execute(target, descriptor, arg, cancellationToken);
    }

    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        }
        catch (Exception e) {
            return new FailedTaskExecution(e);
        }
        return this.compute.submitMapReduce(taskDescriptor, arg, cancellationToken);
    }

    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        return (R)this.compute.executeMapReduce(taskDescriptor, arg, cancellationToken);
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> executeAsyncWithFailover(Set<InternalClusterNode> nodes, ExecutionContext executionContext, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.executeAsyncWithFailover(nodes, executionContext, cancellationToken));
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> submitColocatedInternal(TableViewInternal table, Tuple key, ExecutionContext executionContext, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitColocatedInternal(table, key, executionContext, cancellationToken));
    }

    @Override
    public CompletableFuture<JobExecution<ComputeJobDataHolder>> submitPartitionedInternal(TableViewInternal table, int partitionId, List<DeploymentUnit> units, String jobClassName, JobExecutionOptions options, ComputeEventMetadataBuilder metadataBuilder, SecurityContext securityContext, @Nullable ComputeJobDataHolder arg, @Nullable CancellationToken cancellationToken) {
        return this.checkLicense(() -> this.compute.submitPartitionedInternal(table, partitionId, units, jobClassName, options, metadataBuilder, securityContext, arg, cancellationToken));
    }

    @Override
    public <T, R> TaskExecution<R> submitMapReduceInternal(TaskDescriptor<T, R> taskDescriptor, ComputeEventMetadataBuilder metadataBuilder, SecurityContext securityContext, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
        }
        catch (Exception e) {
            return new FailedTaskExecution(e);
        }
        return this.compute.submitMapReduceInternal(taskDescriptor, metadataBuilder, securityContext, arg, cancellationToken);
    }

    @Override
    public CompletableFuture<Collection<JobState>> statesAsync() {
        return this.checkLicense(() -> this.compute.statesAsync());
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync(UUID jobId) {
        return this.checkLicense(() -> this.compute.stateAsync(jobId));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> cancelAsync(UUID jobId) {
        return this.checkLicense(() -> this.compute.cancelAsync(jobId));
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(UUID jobId, int newPriority) {
        return this.checkLicense(() -> this.compute.changePriorityAsync(jobId, newPriority));
    }

    private <T> CompletableFuture<T> checkLicense(Supplier<CompletableFuture<T>> futureSupplier) {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.COMPUTE);
            return futureSupplier.get();
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)Wrappers.unwrap((Object)this.compute, classToUnwrap);
    }
}

