/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.executor;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.compute.executor.AbstractSecuredTableView;
import org.apache.ignite.internal.table.criteria.CursorAdapter;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.lang.NullableValue;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.tx.Transaction;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Privilege;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

class SecuredKeyValueView<K, V>
extends AbstractSecuredTableView
implements KeyValueView<K, V> {
    private final KeyValueView<K, V> delegate;

    SecuredKeyValueView(KeyValueView<K, V> delegate, Authorizer authorizer, SecurityContext context, QualifiedName name) {
        super(authorizer, context, name);
        this.delegate = delegate;
    }

    @Nullable
    public V get(@Nullable Transaction tx, K key) {
        return this.sync(this.getAsync(tx, key));
    }

    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAsync(tx, key));
    }

    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        return this.sync(this.getNullableAsync(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getNullableAsync(tx, key));
    }

    @Nullable
    public V getOrDefault(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, @Nullable V defaultValue) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getOrDefaultAsync(tx, key, defaultValue));
    }

    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.getAllAsync(tx, keys));
    }

    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.getAllAsync(tx, keys));
    }

    public boolean contains(@Nullable Transaction tx, K key) {
        return this.sync(this.containsAsync(tx, key));
    }

    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAsync(tx, key));
    }

    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.containsAllAsync(tx, keys));
    }

    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.containsAllAsync(tx, keys));
    }

    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        this.sync(this.putAsync(tx, key, val));
    }

    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.putAsync(tx, key, val));
    }

    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        this.sync(this.putAllAsync(tx, pairs));
    }

    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.putAllAsync(tx, pairs));
    }

    @Nullable
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.getAndPutAsync(tx, key, val));
    }

    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.getAndPutAsync(tx, key, val));
    }

    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.getNullableAndPutAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.getNullableAndPutAsync(tx, key, val));
    }

    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.putIfAbsentAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.insertPrivilege(), () -> this.delegate.putIfAbsentAsync(tx, key, val));
    }

    public boolean remove(@Nullable Transaction tx, K key) {
        return this.sync(this.removeAsync(tx, key));
    }

    public boolean remove(@Nullable Transaction tx, K key, V val) {
        return this.sync(this.removeAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAsync(tx, key));
    }

    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAsync(tx, key, val));
    }

    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return this.sync(this.removeAllAsync(tx, keys));
    }

    public void removeAll(@Nullable Transaction tx) {
        this.sync(this.removeAllAsync(tx));
    }

    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAllAsync(tx, keys));
    }

    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return this.authorizer.authorizeThenCompose(this.context, this.deletePrivilege(), () -> this.delegate.removeAllAsync(tx));
    }

    @Nullable
    public V getAndRemove(@Nullable Transaction tx, K key) {
        return this.sync(this.getAndRemoveAsync(tx, key));
    }

    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Set<Privilege> privileges = Set.of(this.selectPrivilege(), this.deletePrivilege());
        return this.authorizer.authorizeThenCompose(this.context, privileges, () -> this.delegate.getAndRemoveAsync(tx, key));
    }

    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.sync(this.getNullableAndRemoveAsync(tx, key));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        Set<Privilege> privileges = Set.of(this.selectPrivilege(), this.deletePrivilege());
        return this.authorizer.authorizeThenCompose(this.context, privileges, () -> this.delegate.getNullableAndRemoveAsync(tx, key));
    }

    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.replaceAsync(tx, key, val));
    }

    public boolean replace(@Nullable Transaction tx, K key, V oldValue, @Nullable V newValue) {
        return this.sync(this.replaceAsync(tx, key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, key, val));
    }

    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.replaceAsync(tx, key, oldVal, newVal));
    }

    @Nullable
    public V getAndReplace(@Nullable Transaction tx, @Nullable K key, @Nullable V val) {
        return this.sync(this.getAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.getAndReplaceAsync(tx, key, val));
    }

    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.sync(this.getNullableAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.authorizer.authorizeThenCompose(this.context, this.replacePrivilege(), () -> this.delegate.getNullableAndReplaceAsync(tx, key, val));
    }

    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.streamData(publisher, options));
    }

    public <E, V2, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V2, A, R> receiver, Function<E, Map.Entry<K, V>> keyFunc, Function<E, V2> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        return this.authorizer.authorizeThenCompose(this.context, this.upsertPrivilege(), () -> this.delegate.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options));
    }

    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber, @Nullable ContinuousQueryOptions options) {
        this.authorizer.authorizeAsync(this.context, this.selectPrivilege()).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                subscriber.onError((Throwable)throwable);
            } else {
                this.delegate.queryContinuously(subscriber, options);
            }
        });
    }

    public Cursor<Map.Entry<K, V>> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return new CursorAdapter(this.sync(this.queryAsync(tx, criteria, indexName, opts)));
    }

    public CompletableFuture<AsyncCursor<Map.Entry<K, V>>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        return this.authorizer.authorizeThenCompose(this.context, this.selectPrivilege(), () -> this.delegate.queryAsync(tx, criteria, indexName, opts));
    }

    public void close() throws Exception {
        this.delegate.close();
    }
}

