/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.configuration;

import org.apache.ignite.internal.util.StringUtils;

public class WasmConfigurationUtils {
    private static final int PAGE_SIZE = 65536;
    private static final long MAX_PAGES = 32767L;

    public static long parseMemorySize(String memSize) {
        return StringUtils.parseStorageStringSize((String)memSize, () -> Runtime.getRuntime().maxMemory());
    }

    public static int memorySizeToPagesValidated(long bytes) {
        long totalPages = (bytes + 65536L - 1L) / 65536L;
        if (totalPages > 32767L) {
            throw new IllegalArgumentException("Wasm requested memory is too large: " + bytes + ". Max allowed: 2147418112 bytes");
        }
        return (int)totalPages;
    }
}

