/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.BroadcastExecution;
import org.apache.ignite.compute.BroadcastJobTarget;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.compute.TaskDescriptor;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.CancellationToken;
import org.gridgain.internal.security.context.GridGainSecurity;
import org.gridgain.internal.security.context.SecurityContext;
import org.jetbrains.annotations.Nullable;

public class SecuredIgniteCompute
implements IgniteCompute,
Wrapper {
    private final IgniteCompute delegate;
    private final SecurityContext securityContext;

    public SecuredIgniteCompute(IgniteCompute delegate, SecurityContext securityContext) {
        this.delegate = delegate;
        this.securityContext = securityContext;
    }

    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.submitAsync(target, descriptor, arg, cancellationToken));
    }

    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (CompletableFuture)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.submitAsync(target, descriptor, arg, cancellationToken));
    }

    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.execute(target, descriptor, arg, cancellationToken));
    }

    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (Collection)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.execute(target, descriptor, arg, cancellationToken));
    }

    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (TaskExecution)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.submitMapReduce(taskDescriptor, arg, cancellationToken));
    }

    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)GridGainSecurity.getWith((SecurityContext)this.securityContext, () -> this.delegate.executeMapReduce(taskDescriptor, arg, cancellationToken));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)Wrappers.unwrap((Object)this.delegate, classToUnwrap);
    }
}

