/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.List;
import java.util.concurrent.Flow;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.internal.compute.ExecutionManager;
import org.apache.ignite.internal.systemview.api.NodeSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.jetbrains.annotations.Nullable;

public class ComputeViewProvider {
    private final DelegatingPublisher publisher = new DelegatingPublisher();

    public void init(ExecutionManager executionManager) {
        this.publisher.executionManager = executionManager;
    }

    public void stop() {
        this.publisher.executionManager = null;
    }

    public SystemView<?> get() {
        NativeType idType = NativeTypes.stringOf((int)36);
        NativeType timestampType = NativeTypes.timestamp((int)9);
        return ((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)((NodeSystemView.Builder)SystemViews.nodeViewBuilder().name("COMPUTE_TASKS")).nodeNameColumnAlias("COORDINATOR_NODE_ID").addColumn("COMPUTE_TASK_ID", idType, info -> info.id().toString())).addColumn("COMPUTE_TASK_STATUS", NativeTypes.stringOf((int)10), info -> info.status().name())).addColumn("COMPUTE_TASK_CREATE_TIME", timestampType, JobState::createTime)).addColumn("COMPUTE_TASK_START_TIME", timestampType, JobState::startTime)).addColumn("COMPUTE_TASK_FINISH_TIME", timestampType, JobState::finishTime)).addColumn("ID", idType, info -> info.id().toString())).addColumn("STATUS", NativeTypes.stringOf((int)10), info -> info.status().name())).addColumn("CREATE_TIME", timestampType, JobState::createTime)).addColumn("START_TIME", timestampType, JobState::startTime)).addColumn("FINISH_TIME", timestampType, JobState::finishTime)).dataProvider((Flow.Publisher)this.publisher)).build();
    }

    private static class DelegatingPublisher
    implements Flow.Publisher<JobState> {
        @Nullable
        private volatile ExecutionManager executionManager;

        private DelegatingPublisher() {
        }

        @Override
        public void subscribe(Flow.Subscriber<? super JobState> subscriber) {
            ExecutionManager execManager = this.executionManager;
            Flow.Publisher jobStatePublisher = execManager != null ? SubscriptionUtils.fromIterable(execManager.localStatesAsync(null)) : SubscriptionUtils.fromIterable(List.of());
            jobStatePublisher.subscribe(subscriber);
        }
    }
}

